/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.rest;

import com.fasterxml.jackson.jakarta.rs.json.JacksonXmlBindJsonProvider;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.apache.directory.scim.core.json.ObjectMapperFactory;
import org.apache.directory.scim.core.schema.SchemaRegistry;
import org.apache.directory.scim.protocol.data.ListResponse;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.schema.ServiceProviderConfiguration;

@Provider
@Consumes(value={"application/scim+json", "application/json"})
@Produces(value={"application/scim+json", "application/json"})
@ApplicationScoped
public class ScimJacksonXmlBindJsonProvider
extends JacksonXmlBindJsonProvider {
    private static final Set<Package> SUPPORTED_PACKAGES = Set.of(ScimResource.class.getPackage(), ListResponse.class.getPackage(), ServiceProviderConfiguration.class.getPackage());

    public ScimJacksonXmlBindJsonProvider() {
    }

    @Inject
    public ScimJacksonXmlBindJsonProvider(SchemaRegistry schemaRegistry) {
        super(ObjectMapperFactory.createObjectMapper((SchemaRegistry)schemaRegistry), DEFAULT_ANNOTATIONS);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isReadable(type, genericType, annotations, mediaType) && SUPPORTED_PACKAGES.contains(type.getPackage());
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isWriteable(type, genericType, annotations, mediaType) && SUPPORTED_PACKAGES.contains(type.getPackage());
    }
}

