/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.directory.scim.core.schema.SchemaRegistry;
import org.apache.directory.scim.protocol.SchemaResource;
import org.apache.directory.scim.protocol.data.ListResponse;
import org.apache.directory.scim.spec.schema.Meta;
import org.apache.directory.scim.spec.schema.Schema;

@ApplicationScoped
public class SchemaResourceImpl
implements SchemaResource {
    private final SchemaRegistry schemaRegistry;

    @Inject
    public SchemaResourceImpl(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public SchemaResourceImpl() {
        this(null);
    }

    public Response getAllSchemas(String filter, UriInfo uriInfo) {
        if (filter != null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ListResponse listResponse = new ListResponse();
        Collection schemas = this.schemaRegistry.getAllSchemas();
        for (Schema schema : schemas) {
            Meta meta = new Meta();
            meta.setLocation(uriInfo.getAbsolutePathBuilder().path(schema.getId()).build(new Object[0]).toString());
            meta.setResourceType("Schema");
            schema.setMeta(meta);
        }
        listResponse.setItemsPerPage(Integer.valueOf(schemas.size()));
        listResponse.setStartIndex(Integer.valueOf(1));
        listResponse.setTotalResults(schemas.size());
        ArrayList objectList = new ArrayList(schemas);
        listResponse.setResources(objectList);
        return Response.ok((Object)listResponse).build();
    }

    public Response getSchema(String urn, UriInfo uriInfo) {
        Schema schema = this.schemaRegistry.getSchema(urn);
        if (schema == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Meta meta = new Meta();
        meta.setLocation(uriInfo.getAbsolutePath().toString());
        meta.setResourceType("Schema");
        schema.setMeta(meta);
        return Response.ok((Object)schema).build();
    }
}

