/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.scim.core.json.ObjectMapperFactory;
import org.apache.directory.scim.core.schema.SchemaRegistry;
import org.apache.directory.scim.server.exception.AttributeDoesNotExistException;
import org.apache.directory.scim.server.exception.AttributeException;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;
import org.apache.directory.scim.spec.resources.ScimExtension;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.schema.AttributeContainer;
import org.apache.directory.scim.spec.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AttributeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttributeUtil.class);
    SchemaRegistry schemaRegistry;
    private final ObjectMapper objectMapper;

    AttributeUtil(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
        this.objectMapper = ObjectMapperFactory.createObjectMapper((SchemaRegistry)schemaRegistry);
    }

    public <T extends ScimResource> T keepAlwaysAttributesForDisplay(T resource) throws AttributeException {
        return this.setAttributesForDisplayInternal(resource, Schema.Attribute.Returned.DEFAULT, Schema.Attribute.Returned.REQUEST, Schema.Attribute.Returned.NEVER);
    }

    public <T extends ScimResource> T setAttributesForDisplay(T resource) throws AttributeException {
        return this.setAttributesForDisplayInternal(resource, Schema.Attribute.Returned.REQUEST, Schema.Attribute.Returned.NEVER);
    }

    private <T extends ScimResource> T setAttributesForDisplayInternal(T resource, Schema.Attribute.Returned ... removeAttributesOfTypes) throws AttributeException {
        T copy = this.cloneScimResource(resource);
        String resourceType = copy.getResourceType();
        Schema schema = this.schemaRegistry.getBaseSchemaOfResourceType(resourceType);
        for (Schema.Attribute.Returned removeAttributesOfType : removeAttributesOfTypes) {
            this.removeAttributesOfType(copy, (AttributeContainer)schema, removeAttributesOfType);
        }
        for (Map.Entry entry : copy.getExtensions().entrySet()) {
            String extensionUrn = (String)entry.getKey();
            ScimExtension scimExtension = (ScimExtension)entry.getValue();
            Schema extensionSchema = this.schemaRegistry.getSchema(extensionUrn);
            for (Schema.Attribute.Returned removeAttributesOfType : removeAttributesOfTypes) {
                this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, removeAttributesOfType);
            }
        }
        return copy;
    }

    public <T extends ScimResource> T setAttributesForDisplay(T resource, Set<AttributeReference> attributes) throws AttributeException {
        if (attributes.isEmpty()) {
            return this.setAttributesForDisplay(resource);
        }
        T copy = this.cloneScimResource(resource);
        String resourceType = copy.getResourceType();
        Schema schema = this.schemaRegistry.getBaseSchemaOfResourceType(resourceType);
        Set<Schema.Attribute> attributesToKeep = this.resolveAttributeReferences(attributes, true);
        HashSet<String> extensionsToRemove = new HashSet<String>();
        this.removeAttributesOfType(copy, (AttributeContainer)schema, Schema.Attribute.Returned.DEFAULT, attributesToKeep);
        this.removeAttributesOfType(copy, (AttributeContainer)schema, Schema.Attribute.Returned.REQUEST, attributesToKeep);
        this.removeAttributesOfType(copy, (AttributeContainer)schema, Schema.Attribute.Returned.NEVER);
        for (Map.Entry extensionEntry : copy.getExtensions().entrySet()) {
            String extensionUrn = (String)extensionEntry.getKey();
            ScimExtension scimExtension = (ScimExtension)extensionEntry.getValue();
            boolean removeExtension = true;
            for (Schema.Attribute attributeToKeep : attributesToKeep) {
                if (!extensionUrn.equalsIgnoreCase(attributeToKeep.getUrn())) continue;
                removeExtension = false;
                break;
            }
            if (removeExtension) {
                extensionsToRemove.add(extensionUrn);
                continue;
            }
            Schema extensionSchema = this.schemaRegistry.getSchema(extensionUrn);
            this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, Schema.Attribute.Returned.DEFAULT, attributesToKeep);
            this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, Schema.Attribute.Returned.REQUEST, attributesToKeep);
            this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, Schema.Attribute.Returned.NEVER);
        }
        for (String extensionUrn : extensionsToRemove) {
            copy.removeExtension(extensionUrn);
        }
        return copy;
    }

    public <T extends ScimResource> T setExcludedAttributesForDisplay(T resource, Set<AttributeReference> excludedAttributes) throws AttributeException {
        if (excludedAttributes.isEmpty()) {
            return this.setAttributesForDisplay(resource);
        }
        T copy = this.cloneScimResource(resource);
        String resourceType = copy.getResourceType();
        Schema schema = this.schemaRegistry.getBaseSchemaOfResourceType(resourceType);
        Set<Schema.Attribute> attributesToRemove = this.resolveAttributeReferences(excludedAttributes, false);
        this.removeAttributesOfType(copy, (AttributeContainer)schema, Schema.Attribute.Returned.REQUEST);
        this.removeAttributesOfType(copy, (AttributeContainer)schema, Schema.Attribute.Returned.NEVER);
        this.removeAttributes(copy, (AttributeContainer)schema, attributesToRemove);
        for (Map.Entry extensionEntry : copy.getExtensions().entrySet()) {
            String extensionUrn = (String)extensionEntry.getKey();
            ScimExtension scimExtension = (ScimExtension)extensionEntry.getValue();
            Schema extensionSchema = this.schemaRegistry.getSchema(extensionUrn);
            this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, Schema.Attribute.Returned.REQUEST);
            this.removeAttributesOfType(scimExtension, (AttributeContainer)extensionSchema, Schema.Attribute.Returned.NEVER);
            this.removeAttributes(scimExtension, (AttributeContainer)extensionSchema, attributesToRemove);
        }
        return copy;
    }

    private <T extends ScimResource> T cloneScimResource(T original) {
        return (T)((ScimResource)this.objectMapper.convertValue(original, original.getClass()));
    }

    private void removeAttributesOfType(Object object, AttributeContainer attributeContainer, Schema.Attribute.Returned returned) throws AttributeException {
        Function<Schema.Attribute, Boolean> function = attribute -> returned == attribute.getReturned();
        this.processAttributes(object, attributeContainer, function);
    }

    private void removeAttributesOfType(Object object, AttributeContainer attributeContainer, Schema.Attribute.Returned returned, Set<Schema.Attribute> attributesToKeep) throws AttributeException {
        Function<Schema.Attribute, Boolean> function = attribute -> !attributesToKeep.contains(attribute) && returned == attribute.getReturned();
        this.processAttributes(object, attributeContainer, function);
    }

    private void removeAttributes(Object object, AttributeContainer attributeContainer, Set<Schema.Attribute> attributesToRemove) throws AttributeException {
        Function<Schema.Attribute, Boolean> function = attribute -> attributesToRemove.contains(attribute);
        this.processAttributes(object, attributeContainer, function);
    }

    private void processAttributes(Object object, AttributeContainer attributeContainer, Function<Schema.Attribute, Boolean> function) throws AttributeException {
        block9: {
            try {
                if (attributeContainer == null || object == null) break block9;
                for (Schema.Attribute attribute : attributeContainer.getAttributes()) {
                    Object[] array;
                    Object subObject;
                    Schema.AttributeAccessor accessor = attribute.getAccessor();
                    if (function.apply(attribute).booleanValue()) {
                        Object obj;
                        if (accessor.getType().isPrimitive() || (obj = accessor.get(object)) == null) continue;
                        log.info("field to be set to null = " + accessor.getType().getName());
                        accessor.set(object, null);
                        continue;
                    }
                    if (!attribute.isMultiValued() && attribute.getType() == Schema.Attribute.Type.COMPLEX) {
                        log.debug("### Processing single value complex field " + attribute.getName());
                        subObject = accessor.get(object);
                        if (subObject == null) continue;
                        Schema.Attribute subAttribute = attributeContainer.getAttribute(attribute.getName());
                        log.debug("### container type = " + attributeContainer.getClass().getName());
                        if (subAttribute == null) {
                            log.debug("#### subattribute == null");
                        }
                        this.processAttributes(subObject, (AttributeContainer)subAttribute, function);
                        continue;
                    }
                    if (!attribute.isMultiValued() || attribute.getType() != Schema.Attribute.Type.COMPLEX) continue;
                    log.debug("### Processing multi-valued complex field " + attribute.getName());
                    subObject = accessor.get(object);
                    if (subObject == null) continue;
                    if (Collection.class.isAssignableFrom(subObject.getClass())) {
                        Collection collection = (Collection)subObject;
                        for (Object o : collection) {
                            Schema.Attribute subAttribute = attributeContainer.getAttribute(attribute.getName());
                            this.processAttributes(o, (AttributeContainer)subAttribute, function);
                        }
                        continue;
                    }
                    if (!accessor.getType().isArray()) continue;
                    for (Object o : array = (Object[])subObject) {
                        Schema.Attribute subAttribute = attributeContainer.getAttribute(attribute.getName());
                        this.processAttributes(o, (AttributeContainer)subAttribute, function);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new AttributeException(e);
            }
        }
    }

    public Set<AttributeReference> getAttributeReferences(String s) {
        String[] split;
        HashSet<AttributeReference> attributeReferences = new HashSet<AttributeReference>();
        for (String af : split = StringUtils.split((String)s, (String)",")) {
            AttributeReference attributeReference = new AttributeReference(af);
            attributeReferences.add(attributeReference);
        }
        return attributeReferences;
    }

    private Set<Schema.Attribute> resolveAttributeReferences(Set<AttributeReference> attributeReferences, boolean includeAttributeChain) throws AttributeDoesNotExistException {
        HashSet<Schema.Attribute> attributes = new HashSet<Schema.Attribute>();
        for (AttributeReference attributeReference : attributeReferences) {
            Set<Schema.Attribute> findAttributes = this.findAttribute(attributeReference, includeAttributeChain);
            if (findAttributes.isEmpty()) continue;
            attributes.addAll(findAttributes);
        }
        return attributes;
    }

    private Set<Schema.Attribute> findAttribute(AttributeReference attributeReference, boolean includeAttributeChain) throws AttributeDoesNotExistException {
        String schemaUrn = attributeReference.getUrn();
        Schema schema = null;
        if (!StringUtils.isEmpty((CharSequence)schemaUrn)) {
            schema = this.schemaRegistry.getSchema(schemaUrn);
            Set<Schema.Attribute> attributes = this.findAttributeInSchema(schema, attributeReference, includeAttributeChain);
            if (attributes.isEmpty()) {
                log.error("Attribute " + attributeReference.getFullyQualifiedAttributeName() + "not found in schema " + schemaUrn);
                throw new AttributeDoesNotExistException(attributeReference.getFullyQualifiedAttributeName());
            }
            return attributes;
        }
        schema = this.schemaRegistry.getSchema("urn:ietf:params:scim:schemas:core:2.0:User");
        Set<Schema.Attribute> attributes = this.findAttributeInSchema(schema, attributeReference, includeAttributeChain);
        if (!attributes.isEmpty()) {
            return attributes;
        }
        schema = this.schemaRegistry.getSchema("urn:ietf:params:scim:schemas:core:2.0:Group");
        attributes = this.findAttributeInSchema(schema, attributeReference, includeAttributeChain);
        if (!attributes.isEmpty()) {
            return attributes;
        }
        log.error("Attribute " + attributeReference.getFullyQualifiedAttributeName() + "not found in any schema.");
        throw new AttributeDoesNotExistException(attributeReference.getFullyQualifiedAttributeName());
    }

    private Set<Schema.Attribute> findAttributeInSchema(Schema schema, AttributeReference attributeReference, boolean includeAttributeChain) {
        if (schema == null) {
            return Collections.emptySet();
        }
        HashSet<Schema.Attribute> attributes = new HashSet<Schema.Attribute>();
        String attributeName = attributeReference.getAttributeName();
        String subAttributeName = attributeReference.getSubAttributeName();
        Schema.Attribute attribute = schema.getAttribute(attributeName);
        if (attribute == null) {
            return Collections.emptySet();
        }
        if (includeAttributeChain || subAttributeName == null) {
            attributes.add(attribute);
        }
        if (subAttributeName != null) {
            if ((attribute = attribute.getAttribute(subAttributeName)) == null) {
                return Collections.emptySet();
            }
            attributes.add(attribute);
        }
        if (attribute.getType() == Schema.Attribute.Type.COMPLEX && includeAttributeChain) {
            Set remaininAttributes = attribute.getAttributes();
            attributes.addAll(remaininAttributes);
        }
        return attributes;
    }
}

