/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.exception;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import org.apache.directory.scim.protocol.ErrorMessageType;
import org.apache.directory.scim.protocol.data.ErrorResponse;
import org.apache.directory.scim.server.exception.BaseScimExceptionMapper;
import org.apache.directory.scim.spec.exception.ResourceException;

@Provider
@Produces(value={"application/scim+json", "application/json"})
public class ResourceExceptionMapper
extends BaseScimExceptionMapper<ResourceException> {
    @Override
    protected ErrorResponse errorResponse(ResourceException e) {
        Response.Status status = Response.Status.fromStatusCode((int)e.getStatus());
        ErrorResponse errorResponse = new ErrorResponse(status, e.getMessage());
        if (status == Response.Status.CONFLICT) {
            errorResponse.setScimType(ErrorMessageType.UNIQUENESS);
            if (e.getMessage() == null) {
                errorResponse.setDetail(ErrorMessageType.UNIQUENESS.getDetail());
            } else {
                errorResponse.setDetail(e.getMessage());
            }
        } else {
            errorResponse.setDetail(e.getMessage());
        }
        return errorResponse;
    }
}

