/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.example.spring.service;

import jakarta.annotation.PostConstruct;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.directory.scim.core.repository.PatchHandler;
import org.apache.directory.scim.core.repository.Repository;
import org.apache.directory.scim.core.schema.SchemaRegistry;
import org.apache.directory.scim.server.exception.UnableToCreateResourceException;
import org.apache.directory.scim.spec.exception.ResourceException;
import org.apache.directory.scim.spec.filter.Filter;
import org.apache.directory.scim.spec.filter.FilterExpressions;
import org.apache.directory.scim.spec.filter.FilterResponse;
import org.apache.directory.scim.spec.filter.PageRequest;
import org.apache.directory.scim.spec.filter.SortRequest;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;
import org.apache.directory.scim.spec.patch.PatchOperation;
import org.apache.directory.scim.spec.resources.ScimExtension;
import org.apache.directory.scim.spec.resources.ScimGroup;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.schema.Schema;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InMemoryGroupService
implements Repository<ScimGroup> {
    private final Map<String, ScimGroup> groups = new HashMap<String, ScimGroup>();
    private final SchemaRegistry schemaRegistry;
    private final PatchHandler patchHandler;

    public InMemoryGroupService(SchemaRegistry schemaRegistry, PatchHandler patchHandler) {
        this.schemaRegistry = schemaRegistry;
        this.patchHandler = patchHandler;
    }

    @PostConstruct
    public void init() {
        ScimGroup group = new ScimGroup();
        group.setId(UUID.randomUUID().toString());
        group.setDisplayName("example-group");
        group.setExternalId("example-group");
        this.groups.put(group.getId(), group);
    }

    public Class<ScimGroup> getResourceClass() {
        return ScimGroup.class;
    }

    public ScimGroup create(ScimGroup resource) throws UnableToCreateResourceException {
        boolean existingGroupFound;
        String id = UUID.randomUUID().toString();
        if (!StringUtils.hasText((String)resource.getExternalId())) {
            resource.setExternalId(resource.getDisplayName());
        }
        if (existingGroupFound = this.groups.values().stream().anyMatch(group -> resource.getExternalId().equals(group.getExternalId()))) {
            throw new UnableToCreateResourceException(Response.Status.CONFLICT, "Group '" + resource.getExternalId() + "' already exists.");
        }
        resource.setId(id);
        this.groups.put(id, resource);
        return resource;
    }

    public ScimGroup update(String id, String version, ScimGroup resource, Set<AttributeReference> includedAttributeReferences, Set<AttributeReference> excludedAttributeReferences) throws ResourceException {
        this.groups.put(id, resource);
        return resource;
    }

    public ScimGroup patch(String id, String version, List<PatchOperation> patchOperations, Set<AttributeReference> includedAttributeReferences, Set<AttributeReference> excludedAttributeReferences) throws ResourceException {
        ScimGroup resource = (ScimGroup)this.patchHandler.apply((ScimResource)this.get(id), patchOperations);
        this.groups.put(id, resource);
        return resource;
    }

    public ScimGroup get(String id) {
        return this.groups.get(id);
    }

    public void delete(String id) {
        this.groups.remove(id);
    }

    public FilterResponse<ScimGroup> find(Filter filter, PageRequest pageRequest, SortRequest sortRequest) {
        long count = pageRequest.getCount() != null ? (long)pageRequest.getCount().intValue() : (long)this.groups.size();
        long startIndex = pageRequest.getStartIndex() != null ? (long)(pageRequest.getStartIndex() - 1) : 0L;
        List result = this.groups.values().stream().skip(startIndex).limit(count).filter(FilterExpressions.inMemory((Filter)filter, (Schema)this.schemaRegistry.getSchema("urn:ietf:params:scim:schemas:core:2.0:Group"))).collect(Collectors.toList());
        return new FilterResponse(result, pageRequest, result.size());
    }

    public List<Class<? extends ScimExtension>> getExtensionList() {
        return Collections.emptyList();
    }
}

