/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.client.rest;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Response;
import org.apache.directory.scim.protocol.data.ErrorResponse;

public class RestException
extends Exception {
    private static final long serialVersionUID = 7360783673606191577L;
    private final int statusCode;
    private final Response.Status status;
    private ErrorResponse errorResponse;

    public RestException(Response response) {
        this.statusCode = response.getStatus();
        this.status = response.getStatusInfo().toEnum();
        try {
            this.errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
        }
        catch (ProcessingException e) {
            this.errorResponse = null;
        }
    }

    public RestException(int statusCode, ErrorResponse errorResponse) {
        this.statusCode = statusCode;
        this.status = Response.Status.fromStatusCode((int)statusCode);
        this.errorResponse = errorResponse;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public ErrorResponse getError() {
        return this.errorResponse;
    }

    @Override
    public String getMessage() {
        String message = "Rest Client Exception: Status Code: " + this.statusCode + " ";
        if (this.errorResponse != null) {
            message = message + "Error Message: " + this.errorResponse.getDetail();
        }
        return message;
    }
}

