/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.client.rest;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import org.apache.directory.scim.client.rest.RestClientUtil;
import org.apache.directory.scim.client.rest.RestException;
import org.apache.directory.scim.client.rest.ScimJacksonXmlBindJsonProvider;
import org.apache.directory.scim.protocol.ResourceTypesResource;
import org.apache.directory.scim.spec.schema.ResourceType;

public class ResourceTypesClient
implements AutoCloseable {
    private static final GenericType<List<ResourceType>> LIST_RESOURCE_TYPE = new GenericType<List<ResourceType>>(){};
    private final Client client;
    private final WebTarget target;
    private final ResourceTypesResourceClient resourceTypesResourceClient = new ResourceTypesResourceClient();

    public ResourceTypesClient(Client client, String baseUrl) {
        this.client = (Client)client.register(ScimJacksonXmlBindJsonProvider.class);
        this.target = this.client.target(baseUrl).path("ResourceTypes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceType> getAllResourceTypes(String filter) throws RestException {
        List resourceTypes;
        Response response = this.resourceTypesResourceClient.getAllResourceTypes(filter);
        try {
            RestClientUtil.checkForSuccess(response);
            resourceTypes = (List)response.readEntity(LIST_RESOURCE_TYPE);
        }
        finally {
            RestClientUtil.close(response);
        }
        return resourceTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ResourceType> getResourceType(String name) throws RestException, ProcessingException, IllegalStateException {
        Optional<ResourceType> resourceType;
        Response response = this.resourceTypesResourceClient.getResourceType(name);
        try {
            resourceType = RestClientUtil.readEntity(response, ResourceType.class);
        }
        finally {
            RestClientUtil.close(response);
        }
        return resourceType;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    private class ResourceTypesResourceClient
    implements ResourceTypesResource {
        private ResourceTypesResourceClient() {
        }

        public Response getAllResourceTypes(String filter) throws RestException {
            Response response = ResourceTypesClient.this.target.queryParam("filter", new Object[]{filter}).request(new String[]{"application/scim+json"}).get();
            return response;
        }

        public Response getResourceType(String name) throws RestException {
            Response response = ResourceTypesClient.this.target.path(name).request(new String[]{"application/scim+json"}).get();
            return response;
        }
    }
}

