/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.tools.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;

public class Lint {
    JsonNode convert(InputStream inputStream) throws JsonProcessingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.readTree(inputStream);
    }

    boolean hasMeta(JsonNode jsonNode) {
        return jsonNode.has("meta");
    }

    boolean hasSchemas(JsonNode jsonNode) {
        return jsonNode.has("schemas");
    }

    boolean isSchema(JsonNode jsonNode) {
        boolean schema = false;
        JsonNode metaJsonNode = jsonNode.get("meta");
        if (metaJsonNode != null) {
            schema = "Schema".equals(metaJsonNode.get("resourceType").asText());
        }
        return schema;
    }

    public boolean lint(InputStream inputStream) throws JsonProcessingException, IOException {
        return this.lint(this.convert(inputStream));
    }

    boolean lint(JsonNode jsonNode) {
        boolean output = true;
        if (jsonNode.isArray()) {
            output = this.lintArray(jsonNode);
        } else if (jsonNode.isObject()) {
            output = this.lintObject(jsonNode);
        }
        return output;
    }

    boolean lintArray(JsonNode arrayJsonNode) {
        boolean output = true;
        for (JsonNode jsonNode : arrayJsonNode) {
            if (!jsonNode.isObject()) continue;
            output = output && this.lintObject(jsonNode);
        }
        return output;
    }

    boolean lintObject(JsonNode objectJsonNode) {
        boolean output = true;
        if (objectJsonNode.isObject()) {
            output = this.isSchema(objectJsonNode) ? this.lintSchema(objectJsonNode) : this.lintResource(objectJsonNode);
        }
        return output;
    }

    boolean lintResource(JsonNode resourceJsonNode) {
        return false;
    }

    boolean lintSchema(JsonNode schemaJsonNode) {
        return false;
    }
}

