/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.schema;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class Mapper {
    static final String ISO8601_PATTERN = "^([0-9]{4})-([0-9]{2})-([0-9]{2})[Tt]([0-9]{2}):([0-9]{2}):([0-9]{2})([Zz]|([+-]{1}[0-9]{2}:[0-9]{2}))";
    static final int DATE_COMPONENT_INDEX_YEAR = 1;
    static final int DATE_COMPONENT_INDEX_MONTH = 2;
    static final int DATE_COMPONENT_INDEX_DAY = 3;
    static final int TIME_COMPONENT_INDEX_HOUR = 4;
    static final int TIME_COMPONENT_INDEX_MINUTE = 5;
    static final int TIME_COMPONENT_INDEX_SECOND = 6;
    static final int TIMEZONE_COMPONENT_INDEX = 7;
    static final String ISO8601_DATETIME_FORMATTER = "yyyy-MM-dd'T'HH:mm:ssXXX";
    SimpleDateFormat iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
    Pattern iso8601Pattern = Pattern.compile("^([0-9]{4})-([0-9]{2})-([0-9]{2})[Tt]([0-9]{2}):([0-9]{2}):([0-9]{2})([Zz]|([+-]{1}[0-9]{2}:[0-9]{2}))");

    public String convertDateTime(Date date) {
        return this.iso8601DateFormat.format(date);
    }

    public Date convertDateTime(String isodate) throws ParseException {
        Date date = this.iso8601DateFormat.parse(isodate);
        return date;
    }

    TimeZone convertTimeZone(String timeZone) {
        String[] timeZoneTokens = timeZone.split(":");
        int hours = 0;
        int minutes = 0;
        if (!timeZone.startsWith("Z") && !timeZone.startsWith("z")) {
            if (timeZoneTokens.length > 0) {
                hours = Integer.parseInt(timeZoneTokens[0]);
            }
            if (timeZoneTokens.length > 1) {
                minutes = Integer.parseInt(timeZoneTokens[1]);
                if (timeZone.startsWith("-")) {
                    minutes *= -1;
                }
            }
        }
        int timeZoneOffsetMilliSeconds = (hours * 60 + minutes) * 1000;
        return new SimpleTimeZone(timeZoneOffsetMilliSeconds, "");
    }
}

