/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.ber.tlv;

import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Strings;

public final class IntegerDecoder {
    private static final int[] MASK = new int[]{255, 65535, 0xFFFFFF, -1};

    public static int parse(BerValue value, int min, int max) throws IntegerDecoderException {
        int result = IntegerDecoder.parseInt(value);
        if (result >= min && result <= max) {
            return result;
        }
        throw new IntegerDecoderException(I18n.err((I18n)I18n.ERR_00038_VALUE_NOT_IN_RANGE, (Object[])new Object[]{min, max}));
    }

    public static int parse(BerValue value) throws IntegerDecoderException {
        return IntegerDecoder.parseInt(value);
    }

    private static int parseInt(BerValue value) throws IntegerDecoderException {
        int result = 0;
        byte[] bytes = value.getData();
        if (Strings.isEmpty((byte[])bytes)) {
            throw new IntegerDecoderException(I18n.err((I18n)I18n.ERR_00036_0_BYTES_LONG_INTEGER, (Object[])new Object[0]));
        }
        if (bytes.length > 4) {
            throw new IntegerDecoderException(I18n.err((I18n)I18n.ERR_00037_ABOVE_4_BYTES_INTEGER, (Object[])new Object[0]));
        }
        for (int i = 0; i < bytes.length; ++i) {
            result = result << 8 | bytes[i] & 0xFF;
        }
        if ((bytes[0] & 0x80) == 128) {
            result = -(~result + 1 & MASK[bytes.length - 1]);
        }
        return result;
    }
}

