/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckNotNullLength<C extends Asn1Container>
extends GrammarAction<C> {
    private static final Logger LOG = LoggerFactory.getLogger(CheckNotNullLength.class);

    public CheckNotNullLength() {
        super("Check that the length is not null");
    }

    @Override
    public void action(C container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
    }
}

