/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.i18n.I18n;

public final class Oid {
    private byte[] oidBytes;
    private String oidString;

    private Oid(String oidString, byte[] oidBytes) {
        this.oidString = oidString;
        this.oidBytes = new byte[oidBytes.length];
        System.arraycopy(oidBytes, 0, this.oidBytes, 0, oidBytes.length);
    }

    public boolean equals(Object other) {
        return other instanceof Oid && this.oidString.equals(((Oid)other).oidString);
    }

    public static Oid fromBytes(byte[] oidBytes) throws DecoderException {
        if (oidBytes == null || oidBytes.length < 1) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{Arrays.toString(oidBytes)}));
        }
        StringBuilder builder = null;
        long value = 0L;
        for (int i = 0; i < oidBytes.length; ++i) {
            value |= (long)(oidBytes[i] & 0x7F);
            if (oidBytes[i] < 0) {
                value <<= 7;
                continue;
            }
            if (builder == null) {
                builder = new StringBuilder();
                if (value >= 80L) {
                    builder.append(2);
                    value -= 80L;
                } else {
                    long one = value / 40L;
                    long two = value % 40L;
                    if (one < 0L || one > 2L || two < 0L || one < 2L && two > 39L) {
                        throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{Arrays.toString(oidBytes)}));
                    }
                    if (one < 2L) {
                        builder.append(one);
                        value = two;
                    }
                }
            }
            builder.append('.').append(value);
            value = 0L;
        }
        if (builder == null) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{Arrays.toString(oidBytes)}));
        }
        return new Oid(builder.toString(), oidBytes);
    }

    public static Oid fromString(String oidString) throws DecoderException {
        if (oidString == null || oidString.isEmpty()) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{""}));
        }
        LinkedList<Long> segments = new LinkedList<Long>();
        for (String segment : oidString.split("\\.", -1)) {
            try {
                segments.add(Long.parseLong(segment));
            }
            catch (NumberFormatException nfe) {
                throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{oidString}), nfe);
            }
        }
        ByteBuffer buffer = new ByteBuffer();
        Long segmentOne = (Long)segments.poll();
        if (segmentOne == null || segmentOne < 0L || segmentOne > 2L) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{oidString}));
        }
        Long segment = (Long)segments.poll();
        if (segment == null || segment < 0L || segmentOne < 2L && segment > 39L) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00033_INVALID_OID, (Object[])new Object[]{oidString}));
        }
        buffer.append(segmentOne * 40L + segment);
        while ((segment = (Long)segments.poll()) != null) {
            buffer.append(segment);
        }
        return new Oid(oidString, buffer.toByteArray());
    }

    public int getEncodedLength() {
        return this.oidBytes.length;
    }

    public int hashCode() {
        return this.oidString.hashCode();
    }

    public static boolean isOid(String oidString) {
        try {
            Oid.fromString(oidString);
            return true;
        }
        catch (DecoderException e) {
            return false;
        }
    }

    public byte[] toBytes() {
        return Arrays.copyOf(this.oidBytes, this.oidBytes.length);
    }

    public String toString() {
        return this.oidString;
    }

    public void writeBytesTo(java.nio.ByteBuffer buffer) {
        buffer.put(this.oidBytes);
    }

    public void writeBytesTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.oidBytes);
    }

    private static final class ByteBuffer {
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        private ByteBuffer() {
        }

        public ByteBuffer append(long value) {
            this.write(value, false);
            return this;
        }

        private void write(long value, boolean hasMore) {
            long remaining = value >> 7;
            if (remaining > 0L) {
                this.write(remaining, true);
            }
            this.buffer.write(hasMore ? (byte)(0x7FL & value | 0x80L) : (byte)(0x7FL & value));
        }

        public byte[] toByteArray() {
            return this.buffer.toByteArray();
        }
    }
}

