/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.net.ssl.SSLException;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

final class ClientThread
extends Thread {
    NetworkServerControlImpl parent;
    ServerSocket serverSocket;
    private int timeSlice;
    private int connNum;

    ClientThread(NetworkServerControlImpl networkServerControlImpl, ServerSocket serverSocket) {
        NetworkServerControlImpl.setUniqueThreadName(this, "NetworkServerThread");
        this.parent = networkServerControlImpl;
        this.serverSocket = serverSocket;
        this.timeSlice = networkServerControlImpl.getTimeSlice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Socket socket = null;
        while (true) {
            try {
                try {
                    try {
                        while (true) {
                            socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return ClientThread.this.serverSocket.accept();
                                }
                            });
                            if (this.parent.getShutdown()) {
                                socket.close();
                                return;
                            }
                            socket.setKeepAlive(this.parent.getKeepAlive());
                            if (this.timeSlice > 0) {
                                socket.setSoTimeout(this.timeSlice);
                            }
                            this.parent.addSession(socket);
                        }
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (SSLException sSLException) {
                    this.parent.consoleExceptionPrintTrace(sSLException);
                    this.parent.directShutdownInternal();
                    return;
                }
                catch (IOException iOException) {
                    Object object = this.parent.getShutdownSync();
                    synchronized (object) {
                        if (!this.parent.getShutdown()) {
                            this.parent.consoleExceptionPrintTrace(iOException);
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        return;
                    }
                }
            }
            catch (Exception exception) {
                this.parent.consoleExceptionPrintTrace(exception);
                try {
                    if (socket == null) continue;
                    socket.close();
                    continue;
                }
                catch (IOException iOException) {
                    this.parent.consoleExceptionPrintTrace(iOException);
                    continue;
                }
            }
            break;
        }
    }
}

