/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

class PigUtil {
    static final ResizeFactor RF = ResizeFactor.X8;

    PigUtil() {
    }

    static final Tuple compactOrderedSketchToTuple(CompactSketch sketch) {
        Tuple outputTuple = TupleFactory.getInstance().newTuple(1);
        byte[] bytes = sketch.toByteArray();
        DataByteArray dba = new DataByteArray(bytes);
        if (!sketch.isOrdered()) {
            throw new IllegalArgumentException("Given sketch must be ordered.");
        }
        try {
            outputTuple.set(0, (Object)dba);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException thrown: " + e);
        }
        return outputTuple;
    }

    static final Sketch tupleToSketch(Tuple tuple, long seed) {
        DataByteArray sketchDBA = null;
        sketchDBA = (DataByteArray)PigUtil.extractFieldAtIndex(tuple, 0);
        Memory srcMem = Memory.wrap((byte[])sketchDBA.get());
        Sketch sketch = Sketch.wrap((Memory)srcMem, (long)seed);
        return sketch;
    }

    static final DataBag extractBag(Tuple tuple) {
        DataBag bag = null;
        try {
            bag = (DataBag)tuple.get(0);
            if (bag.size() == 0L) {
                return null;
            }
        }
        catch (IOException | IndexOutOfBoundsException | NullPointerException e) {
            return null;
        }
        return bag;
    }

    static final Object extractFieldAtIndex(Tuple tuple, int index) {
        Object fi = null;
        try {
            fi = tuple.get(index);
            fi.hashCode();
        }
        catch (IOException | IndexOutOfBoundsException | NullPointerException e) {
            return null;
        }
        return fi;
    }

    static final Byte extractTypeAtIndex(Tuple tuple, int index) {
        Byte type = null;
        try {
            type = tuple.getType(index);
        }
        catch (IOException | IndexOutOfBoundsException | NullPointerException e) {
            return null;
        }
        return type;
    }

    static final Tuple emptySketchTuple(long seed) {
        UpdateSketch sketch = UpdateSketch.builder().setSeed(seed).setResizeFactor(RF).setNominalEntries(16).build();
        CompactSketch compOrdSketch = sketch.compact(true, null);
        return PigUtil.compactOrderedSketchToTuple(compOrdSketch);
    }
}

