/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Set;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.NativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.NonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.ResourceImpl;

public abstract class WritableMemoryImpl
extends ResourceImpl
implements WritableMemory {
    WritableMemoryImpl(MemorySegment seg, int typeId, MemoryRequestServer memReqSvr, Arena arena) {
        super(seg, typeId, memReqSvr, arena);
    }

    public static WritableMemory wrapSegmentAsArray(MemorySegment seg, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null");
        int type = 0 | (seg.isReadOnly() ? 1 : 0);
        if (byteOrder == NON_NATIVE_BYTE_ORDER) {
            return new NonNativeWritableMemoryImpl(seg, type |= 0x20, memReqSvr, null);
        }
        return new NativeWritableMemoryImpl(seg, type, memReqSvr, null);
    }

    public static WritableMemory wrapByteBuffer(ByteBuffer byteBuffer, boolean localReadOnly, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        ByteBuffer byteBufView;
        Objects.requireNonNull(byteBuffer, "ByteBuffer must not be null");
        Objects.requireNonNull(byteOrder, "ByteOrder must not be null");
        if (localReadOnly) {
            byteBufView = byteBuffer.isReadOnly() ? byteBuffer.duplicate() : byteBuffer.asReadOnlyBuffer();
        } else {
            if (byteBuffer.isReadOnly()) {
                throw new IllegalArgumentException("ByteBuffer must be writable.");
            }
            byteBufView = byteBuffer.duplicate();
        }
        byteBufView.clear();
        MemorySegment seg = MemorySegment.ofBuffer(byteBufView);
        int type = 0x80 | (localReadOnly ? 1 : 0) | (seg.isNative() ? 8 : 0) | (seg.isMapped() ? 16 : 0);
        WritableMemoryImpl wmem = byteOrder == NON_NATIVE_BYTE_ORDER ? new NonNativeWritableMemoryImpl(seg, type |= 0x20, memReqSvr, null) : new NativeWritableMemoryImpl(seg, type, memReqSvr, null);
        return wmem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WritableMemory wrapMap(File file, long fileOffsetBytes, long capacityBytes, ByteOrder byteOrder, boolean localReadOnly, Arena arena) throws IllegalArgumentException, IOException {
        FileChannel.MapMode mapMode;
        Objects.requireNonNull(arena, "Arena must be non-null.");
        Objects.requireNonNull(file, "File must be non-null.");
        Objects.requireNonNull(byteOrder, "ByteOrder must be non-null.");
        boolean fileCanRead = file.canRead();
        if (localReadOnly) {
            if (!fileCanRead) throw new IllegalArgumentException("File must be readable.");
            mapMode = FileChannel.MapMode.READ_ONLY;
        } else {
            if (!fileCanRead || !file.canWrite()) throw new IllegalArgumentException("File must be readable and writable.");
            mapMode = FileChannel.MapMode.READ_WRITE;
        }
        Set<StandardOpenOption> openOptions = FileChannel.MapMode.READ_WRITE.equals(mapMode) ? Set.of(StandardOpenOption.READ, StandardOpenOption.WRITE) : Set.of(StandardOpenOption.READ);
        boolean nativeBOType = byteOrder == ByteOrder.nativeOrder();
        int type = 0x18 | (localReadOnly ? 1 : 0) | (nativeBOType ? 0 : 32);
        try (FileChannel fileChannel = FileChannel.open(file.toPath(), openOptions, new FileAttribute[0]);){
            MemorySegment seg = fileChannel.map(mapMode, fileOffsetBytes, capacityBytes, arena);
            WritableMemoryImpl writableMemoryImpl = nativeBOType ? new NativeWritableMemoryImpl(seg, type, null, arena) : new NonNativeWritableMemoryImpl(seg, type, null, arena);
            return writableMemoryImpl;
        }
    }

    public static WritableMemory wrapDirect(long capacityBytes, long alignmentBytes, ByteOrder byteOrder, MemoryRequestServer memReqSvr, Arena arena) {
        Objects.requireNonNull(arena, "Arena must be non-null");
        Objects.requireNonNull(byteOrder, "ByteOrder must be non-null");
        MemorySegment seg = arena.allocate(capacityBytes, alignmentBytes);
        boolean nativeBOType = byteOrder == ByteOrder.nativeOrder();
        int type = 8 | (nativeBOType ? 0 : 32);
        return nativeBOType ? new NativeWritableMemoryImpl(seg, type, memReqSvr, arena) : new NonNativeWritableMemoryImpl(seg, type, memReqSvr, arena);
    }

    @Override
    public Memory region(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        return this.regionImpl(offsetBytes, capacityBytes, true, byteOrder);
    }

    @Override
    public WritableMemory writableRegion(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Cannot create a writable region from a read-only Memory.");
        }
        return this.regionImpl(offsetBytes, capacityBytes, false, byteOrder);
    }

    private WritableMemory regionImpl(long offsetBytes, long capacityBytes, boolean localReadOnly, ByteOrder byteOrder) {
        if (!this.isAlive()) {
            throw new IllegalStateException("This Memory is not alive.");
        }
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null.");
        boolean readOnly = this.isReadOnly() || localReadOnly;
        MemorySegment slice = readOnly && !this.seg.isReadOnly() ? this.seg.asSlice(offsetBytes, capacityBytes).asReadOnly() : this.seg.asSlice(offsetBytes, capacityBytes);
        boolean duplicateType = this.isDuplicate();
        boolean mapType = this.seg.isMapped();
        boolean directType = this.seg.isNative();
        boolean nativeBOType = byteOrder == ByteOrder.nativeOrder();
        boolean byteBufferType = this.hasByteBuffer();
        int type = 2 | (readOnly ? 1 : 0) | (duplicateType ? 4 : 0) | (mapType ? 16 : 0) | (directType ? 8 : 0) | (nativeBOType ? 0 : 32) | (byteBufferType ? 128 : 0);
        WritableMemory wmem = WritableMemoryImpl.selectMemory(slice, type, this.memReqSvr, byteBufferType, mapType, nativeBOType);
        return wmem;
    }

    @Override
    public Buffer asBuffer(ByteOrder byteOrder) {
        return this.asWritableBufferImpl(true, byteOrder);
    }

    @Override
    public WritableBuffer asWritableBuffer(ByteOrder byteOrder) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Cannot create a writable buffer from a read-only Memory.");
        }
        return this.asWritableBufferImpl(false, byteOrder);
    }

    private WritableBuffer asWritableBufferImpl(boolean localReadOnly, ByteOrder byteOrder) {
        if (!this.isAlive()) {
            throw new IllegalStateException("This Memory is not alive.");
        }
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null");
        boolean readOnly = this.isReadOnly() || localReadOnly;
        MemorySegment seg2 = readOnly && !this.seg.isReadOnly() ? this.seg.asReadOnly() : this.seg;
        boolean regionType = this.isRegion();
        boolean duplicateType = this.isDuplicate();
        boolean mapType = this.seg.isMapped();
        boolean directType = this.seg.isNative();
        boolean nativeBOType = byteOrder == ByteOrder.nativeOrder();
        boolean byteBufferType = this.hasByteBuffer();
        int type = 0x40 | (readOnly ? 1 : 0) | (regionType ? 2 : 0) | (duplicateType ? 4 : 0) | (directType ? 8 : 0) | (mapType ? 16 : 0) | (nativeBOType ? 0 : 32) | (byteBufferType ? 128 : 0);
        WritableBuffer wbuf = WritableMemoryImpl.selectBuffer(seg2, type, this.memReqSvr, byteBufferType, mapType, nativeBOType);
        wbuf.setStartPositionEnd(0L, 0L, wbuf.getCapacity());
        return wbuf;
    }

    @Override
    public final boolean getBoolean(long offsetBytes) {
        return this.getByte(offsetBytes) != 0;
    }

    @Override
    public final byte getByte(long offsetBytes) {
        return this.seg.get(ValueLayout.JAVA_BYTE, offsetBytes);
    }

    @Override
    public final void getByteArray(long offsetBytes, byte[] dstArray, int dstOffsetBytes, int lengthBytes) {
        MemorySegment dstSeg = MemorySegment.ofArray(dstArray);
        MemorySegment.copy(this.seg, offsetBytes, dstSeg, dstOffsetBytes, lengthBytes);
    }

    @Override
    public final void copyTo(long srcOffsetBytes, WritableMemory destination, long dstOffsetBytes, long lengthBytes) {
        MemorySegment.copy(this.seg, srcOffsetBytes, ((ResourceImpl)((Object)destination)).seg, dstOffsetBytes, lengthBytes);
    }

    @Override
    public final void writeToByteStream(long offsetBytes, int lengthBytes, ByteArrayOutputStream out) throws IOException {
        WritableMemoryImpl.checkBounds(offsetBytes, lengthBytes, this.seg.byteSize());
        byte[] bArr = new byte[lengthBytes];
        this.getByteArray(offsetBytes, bArr, 0, lengthBytes);
        out.writeBytes(bArr);
    }

    @Override
    public final void putBoolean(long offsetBytes, boolean value) {
        this.putByte(offsetBytes, value ? (byte)1 : 0);
    }

    @Override
    public final void putByte(long offsetBytes, byte value) {
        this.seg.set(ValueLayout.JAVA_BYTE, offsetBytes, value);
    }

    @Override
    public final void putByteArray(long offsetBytes, byte[] srcArray, int srcOffsetBytes, int lengthBytes) {
        MemorySegment srcSeg = MemorySegment.ofArray(srcArray);
        MemorySegment.copy(srcSeg, srcOffsetBytes, this.seg, offsetBytes, lengthBytes);
    }

    @Override
    public final void clear() {
        this.seg.fill((byte)0);
    }

    @Override
    public final void clear(long offsetBytes, long lengthBytes) {
        MemorySegment slice = this.seg.asSlice(offsetBytes, lengthBytes);
        slice.fill((byte)0);
    }

    @Override
    public final void clearBits(long offsetBytes, byte bitMask) {
        byte b = this.seg.get(ValueLayout.JAVA_BYTE, offsetBytes);
        this.seg.set(ValueLayout.JAVA_BYTE, offsetBytes, (byte)(b & ~bitMask));
    }

    @Override
    public final void fill(byte value) {
        this.seg.fill(value);
    }

    @Override
    public final void fill(long offsetBytes, long lengthBytes, byte value) {
        MemorySegment slice = this.seg.asSlice(offsetBytes, lengthBytes);
        slice.fill(value);
    }

    @Override
    public final byte[] getArray() {
        return this.seg.toArray(ValueLayout.JAVA_BYTE);
    }

    @Override
    public final void setBits(long offsetBytes, byte bitMask) {
        byte b = this.seg.get(ValueLayout.JAVA_BYTE, offsetBytes);
        this.seg.set(ValueLayout.JAVA_BYTE, offsetBytes, (byte)(b | bitMask));
    }
}

