/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.BBNonNativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.BBWritableBufferImpl;
import org.apache.datasketches.memory.internal.BBWritableMemoryImpl;
import org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.internal.NonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.Util;

final class BBNonNativeWritableMemoryImpl
extends NonNativeWritableMemoryImpl {
    private final ByteBuffer byteBuf;
    private final Object unsafeObj;
    private final long nativeBaseOffset;

    BBNonNativeWritableMemoryImpl(Object unsafeObj, long nativeBaseOffset, long offsetBytes, long capacityBytes, int typeId, long cumOffsetBytes, MemoryRequestServer memReqSvr, ByteBuffer byteBuf) {
        this.unsafeObj = unsafeObj;
        this.nativeBaseOffset = nativeBaseOffset;
        this.offsetBytes = offsetBytes;
        this.capacityBytes = capacityBytes;
        this.typeId = BBNonNativeWritableMemoryImpl.removeNnBuf(typeId) | 0x80 | 0 | 0x20;
        this.cumOffsetBytes = cumOffsetBytes;
        this.memReqSvr = memReqSvr;
        this.byteBuf = byteBuf;
        if (this.owner != null && this.owner != Thread.currentThread()) {
            throw new IllegalStateException("Attempted access outside owning thread");
        }
        this.owner = Thread.currentThread();
    }

    @Override
    BaseWritableMemoryImpl toWritableRegion(long regionOffsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        long newOffsetBytes = this.offsetBytes + regionOffsetBytes;
        long newCumOffsetBytes = this.cumOffsetBytes + regionOffsetBytes;
        int typeIdOut = BBNonNativeWritableMemoryImpl.removeNnBuf(this.typeId) | 0 | 2 | (readOnly ? 1 : 0);
        if (Util.isNativeByteOrder(byteOrder)) {
            return new BBWritableMemoryImpl(this.unsafeObj, this.nativeBaseOffset, newOffsetBytes, capacityBytes, typeIdOut |= 0, newCumOffsetBytes, this.memReqSvr, this.byteBuf);
        }
        return new BBNonNativeWritableMemoryImpl(this.unsafeObj, this.nativeBaseOffset, newOffsetBytes, capacityBytes, typeIdOut |= 0x20, newCumOffsetBytes, this.memReqSvr, this.byteBuf);
    }

    @Override
    BaseWritableBufferImpl toWritableBuffer(boolean readOnly, ByteOrder byteOrder) {
        int typeIdOut = BBNonNativeWritableMemoryImpl.removeNnBuf(this.typeId) | 0x40 | (readOnly ? 1 : 0);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return new BBWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, this.offsetBytes, this.capacityBytes, typeIdOut |= 0, this.cumOffsetBytes, this.memReqSvr, this.byteBuf);
        }
        return new BBNonNativeWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, this.offsetBytes, this.capacityBytes, typeIdOut |= 0x20, this.cumOffsetBytes, this.memReqSvr, this.byteBuf);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuf;
    }

    @Override
    Object getUnsafeObject() {
        return this.unsafeObj;
    }
}

