/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseWritableBufferImpl;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.MapNonNativeWritableBufferImpl;
import org.apache.datasketches.memory.StepBoolean;
import org.apache.datasketches.memory.WritableBufferImpl;

final class MapWritableBufferImpl
extends WritableBufferImpl {
    private static final int id = 80;
    private final long nativeBaseOffset;
    private final StepBoolean valid;
    private final byte typeId;

    MapWritableBufferImpl(long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, StepBoolean valid, BaseWritableMemoryImpl originMemory) {
        super(null, nativeBaseOffset, regionOffset, capacityBytes, originMemory);
        this.nativeBaseOffset = nativeBaseOffset;
        this.valid = valid;
        this.typeId = (byte)(0x50 | typeId & 7);
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 2 | (readOnly ? 1 : 0);
        return MapWritableBufferImpl.isNativeByteOrder(byteOrder) ? new MapWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.originMemory) : new MapNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.originMemory);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 4 | (readOnly ? 1 : 0);
        return MapWritableBufferImpl.isNativeByteOrder(byteOrder) ? new MapWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.originMemory) : new MapNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.originMemory);
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }
}

