/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.CompareAndCopy;
import org.apache.datasketches.memory.HeapWritableBufferImpl;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.ReadOnlyException;
import org.apache.datasketches.memory.UnsafeUtil;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableBufferImpl;
import org.apache.datasketches.memory.WritableMemory;

abstract class BaseWritableBufferImpl
extends WritableBuffer {
    final BaseWritableMemoryImpl originMemory;
    static final WritableBufferImpl ZERO_SIZE_BUFFER;

    BaseWritableBufferImpl(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes, BaseWritableMemoryImpl originMemory) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes);
        this.originMemory = originMemory;
    }

    @Override
    public Buffer region() {
        return this.writableRegionImpl(this.getPosition(), this.getEnd() - this.getPosition(), true, this.getTypeByteOrder());
    }

    @Override
    public Buffer region(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        WritableBuffer buf = this.writableRegionImpl(offsetBytes, capacityBytes, true, byteOrder);
        buf.setAndCheckStartPositionEnd(0L, 0L, capacityBytes);
        return buf;
    }

    @Override
    public WritableBuffer writableRegion() {
        return this.writableRegionImpl(this.getPosition(), this.getEnd() - this.getPosition(), false, this.getTypeByteOrder());
    }

    @Override
    public WritableBuffer writableRegion(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        WritableBuffer wbuf = this.writableRegionImpl(offsetBytes, capacityBytes, false, byteOrder);
        wbuf.setAndCheckStartPositionEnd(0L, 0L, capacityBytes);
        return wbuf;
    }

    WritableBuffer writableRegionImpl(long offsetBytes, long capacityBytes, boolean localReadOnly, ByteOrder byteOrder) {
        if (capacityBytes == 0L) {
            return ZERO_SIZE_BUFFER;
        }
        if (this.isReadOnly() && !localReadOnly) {
            throw new ReadOnlyException("Writable region of a read-only Buffer is not allowed.");
        }
        this.checkValidAndBounds(offsetBytes, capacityBytes);
        boolean readOnly = this.isReadOnly() || localReadOnly;
        BaseWritableBufferImpl wbuf = this.toWritableRegion(offsetBytes, capacityBytes, readOnly, byteOrder);
        wbuf.setStartPositionEnd(0L, 0L, capacityBytes);
        return wbuf;
    }

    abstract BaseWritableBufferImpl toWritableRegion(long var1, long var3, boolean var5, ByteOrder var6);

    @Override
    public Buffer duplicate() {
        return this.writableDuplicateImpl(true, this.getTypeByteOrder());
    }

    @Override
    public Buffer duplicate(ByteOrder byteOrder) {
        return this.writableDuplicateImpl(true, byteOrder);
    }

    @Override
    public WritableBuffer writableDuplicate() {
        return this.writableDuplicateImpl(false, this.getTypeByteOrder());
    }

    @Override
    public WritableBuffer writableDuplicate(ByteOrder byteOrder) {
        return this.writableDuplicateImpl(false, byteOrder);
    }

    WritableBuffer writableDuplicateImpl(boolean localReadOnly, ByteOrder byteOrder) {
        if (this.isReadOnly() && !localReadOnly) {
            throw new ReadOnlyException("Writable duplicate of a read-only Buffer is not allowed.");
        }
        boolean readOnly = this.isReadOnly() || localReadOnly;
        BaseWritableBufferImpl wbuf = this.toDuplicate(readOnly, byteOrder);
        wbuf.setStartPositionEnd(this.getStart(), this.getPosition(), this.getEnd());
        return wbuf;
    }

    abstract BaseWritableBufferImpl toDuplicate(boolean var1, ByteOrder var2);

    @Override
    public Memory asMemory() {
        return this.originMemory;
    }

    @Override
    public WritableMemory asWritableMemory() {
        if (this.isReadOnly()) {
            throw new ReadOnlyException("Converting a read-only Buffer to a writable Memory is not allowed.");
        }
        return this.originMemory;
    }

    @Override
    public final boolean getBoolean() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 1L);
        return UnsafeUtil.unsafe.getBoolean(this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }

    @Override
    public final boolean getBoolean(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 1L);
        return UnsafeUtil.unsafe.getBoolean(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    @Override
    public final void getBooleanArray(boolean[] dstArray, int dstOffsetBooleans, int lengthBooleans) {
        long pos = this.getPosition();
        long copyBytes = lengthBooleans;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetBooleans, lengthBooleans, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.getUnsafeObject(), this.getCumulativeOffset(pos), dstArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (long)dstOffsetBooleans, copyBytes);
    }

    @Override
    public final byte getByte() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 1L);
        return UnsafeUtil.unsafe.getByte(this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }

    @Override
    public final byte getByte(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 1L);
        return UnsafeUtil.unsafe.getByte(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    @Override
    public final void getByteArray(byte[] dstArray, int dstOffsetBytes, int lengthBytes) {
        long pos = this.getPosition();
        long copyBytes = lengthBytes;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetBytes, lengthBytes, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.getUnsafeObject(), this.getCumulativeOffset(pos), dstArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (long)dstOffsetBytes, copyBytes);
    }

    final char getNativeOrderedChar() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 2L);
        return UnsafeUtil.unsafe.getChar(this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }

    final char getNativeOrderedChar(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 2L);
        return UnsafeUtil.unsafe.getChar(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    final int getNativeOrderedInt() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 4L);
        return UnsafeUtil.unsafe.getInt(this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }

    final int getNativeOrderedInt(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 4L);
        return UnsafeUtil.unsafe.getInt(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    final long getNativeOrderedLong() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 8L);
        return UnsafeUtil.unsafe.getLong(this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }

    final long getNativeOrderedLong(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 8L);
        return UnsafeUtil.unsafe.getLong(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    final short getNativeOrderedShort() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 2L);
        return UnsafeUtil.unsafe.getShort(this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }

    final short getNativeOrderedShort(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 2L);
        return UnsafeUtil.unsafe.getShort(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    @Override
    public final int compareTo(long thisOffsetBytes, long thisLengthBytes, Buffer thatBuf, long thatOffsetBytes, long thatLengthBytes) {
        return CompareAndCopy.compare(this, thisOffsetBytes, thisLengthBytes, thatBuf, thatOffsetBytes, thatLengthBytes);
    }

    @Override
    public final void putBoolean(boolean value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 1L);
        UnsafeUtil.unsafe.putBoolean(this.getUnsafeObject(), this.getCumulativeOffset(pos), value);
    }

    @Override
    public final void putBoolean(long offsetBytes, boolean value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        UnsafeUtil.unsafe.putBoolean(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    @Override
    public final void putBooleanArray(boolean[] srcArray, int srcOffsetBooleans, int lengthBooleans) {
        long pos = this.getPosition();
        long copyBytes = lengthBooleans;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetBooleans, lengthBooleans, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (long)srcOffsetBooleans, this.getUnsafeObject(), this.getCumulativeOffset(pos), copyBytes);
    }

    @Override
    public final void putByte(byte value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 1L);
        UnsafeUtil.unsafe.putByte(this.getUnsafeObject(), this.getCumulativeOffset(pos), value);
    }

    @Override
    public final void putByte(long offsetBytes, byte value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        UnsafeUtil.unsafe.putByte(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    @Override
    public final void putByteArray(byte[] srcArray, int srcOffsetBytes, int lengthBytes) {
        long pos = this.getPosition();
        long copyBytes = lengthBytes;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetBytes, lengthBytes, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (long)srcOffsetBytes, this.getUnsafeObject(), this.getCumulativeOffset(pos), copyBytes);
    }

    final void putNativeOrderedChar(char value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 2L);
        UnsafeUtil.unsafe.putChar(this.getUnsafeObject(), this.getCumulativeOffset(pos), value);
    }

    final void putNativeOrderedChar(long offsetBytes, char value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 2L);
        UnsafeUtil.unsafe.putChar(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    final void putNativeOrderedInt(int value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 4L);
        UnsafeUtil.unsafe.putInt(this.getUnsafeObject(), this.getCumulativeOffset(pos), value);
    }

    final void putNativeOrderedInt(long offsetBytes, int value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 4L);
        UnsafeUtil.unsafe.putInt(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    final void putNativeOrderedLong(long value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 8L);
        UnsafeUtil.unsafe.putLong(this.getUnsafeObject(), this.getCumulativeOffset(pos), value);
    }

    final void putNativeOrderedLong(long offsetBytes, long value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        UnsafeUtil.unsafe.putLong(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    final void putNativeOrderedShort(short value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 2L);
        UnsafeUtil.unsafe.putShort(this.getUnsafeObject(), this.getCumulativeOffset(pos), value);
    }

    final void putNativeOrderedShort(long offsetBytes, short value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 2L);
        UnsafeUtil.unsafe.putShort(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    @Override
    public final Object getArray() {
        this.assertValid();
        return this.getUnsafeObject();
    }

    @Override
    public final void clear() {
        this.fill((byte)0);
    }

    @Override
    public final void fill(byte value) {
        long chunk;
        long len;
        this.checkValidForWrite();
        long pos = this.getPosition();
        BaseWritableBufferImpl.checkInvariants(this.getStart(), pos + len, this.getEnd(), this.getCapacity());
        for (len = this.getEnd() - pos; len > 0L; len -= chunk) {
            chunk = Math.min(len, 0x100000L);
            UnsafeUtil.unsafe.setMemory(this.getUnsafeObject(), this.getCumulativeOffset(pos), chunk, value);
            pos += chunk;
        }
    }

    static {
        BaseWritableMemoryImpl mem = BaseWritableMemoryImpl.ZERO_SIZE_MEMORY;
        ZERO_SIZE_BUFFER = new HeapWritableBufferImpl((Object)new byte[0], 0L, 0L, 1, mem);
    }
}

