/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.reflect.Array;
import java.util.Comparator;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantilescommon.GenericInequalitySearch;
import org.apache.datasketches.quantilescommon.GenericPartitionBoundaries;
import org.apache.datasketches.quantilescommon.GenericSortedView;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.apache.datasketches.quantilescommon.PartitioningFeature;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public class KllItemsSketchSortedView<T>
implements GenericSortedView<T>,
PartitioningFeature<T> {
    private final T[] quantiles;
    private final long[] cumWeights;
    private final long totalN;
    private final Comparator<? super T> comparator;
    private final T maxItem;
    private final T minItem;
    private final Class<T> clazz;

    KllItemsSketchSortedView(T[] quantiles, long[] cumWeights, long totalN, Comparator<? super T> comparator, T maxItem, T minItem) {
        this.quantiles = quantiles;
        this.cumWeights = cumWeights;
        this.totalN = totalN;
        this.comparator = comparator;
        this.maxItem = maxItem;
        this.minItem = minItem;
        this.clazz = quantiles[0].getClass();
    }

    @Override
    public double[] getCDF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        GenericSortedView.validateItems(splitPoints, this.comparator);
        int len = splitPoints.length + 1;
        double[] buckets = new double[len];
        for (int i = 0; i < len - 1; ++i) {
            buckets[i] = this.getRank(splitPoints[i], searchCrit);
        }
        buckets[len - 1] = 1.0;
        return buckets;
    }

    @Override
    public long[] getCumulativeWeights() {
        return (long[])this.cumWeights.clone();
    }

    @Override
    public T getMaxItem() {
        return this.maxItem;
    }

    @Override
    public T getMinItem() {
        return this.minItem;
    }

    @Override
    public long getN() {
        return this.totalN;
    }

    @Override
    public GenericPartitionBoundaries<T> getPartitionBoundaries(int numEquallySized, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        long totalN = this.totalN;
        int svLen = this.cumWeights.length;
        this.cumWeights[0] = 1L;
        this.cumWeights[svLen - 1] = totalN;
        this.quantiles[0] = this.getMinItem();
        this.quantiles[svLen - 1] = this.getMaxItem();
        double[] evSpNormRanks = QuantilesUtil.evenlySpacedDoubles(0.0, 1.0, numEquallySized + 1);
        int len = evSpNormRanks.length;
        Object[] evSpQuantiles = (Object[])Array.newInstance(this.clazz, len);
        long[] evSpNatRanks = new long[len];
        for (int i = 0; i < len; ++i) {
            int index = this.getQuantileIndex(evSpNormRanks[i], searchCrit);
            evSpQuantiles[i] = this.quantiles[index];
            evSpNatRanks[i] = this.cumWeights[index];
        }
        GenericPartitionBoundaries<Object> gpb = new GenericPartitionBoundaries<Object>(this.totalN, evSpQuantiles, evSpNatRanks, evSpNormRanks, this.getMaxItem(), this.getMinItem(), searchCrit);
        return gpb;
    }

    @Override
    public double[] getPMF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        int len;
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        GenericSortedView.validateItems(splitPoints, this.comparator);
        double[] buckets = this.getCDF(splitPoints, searchCrit);
        int i = len = buckets.length;
        while (i-- > 1) {
            int n = i;
            buckets[n] = buckets[n] - buckets[i - 1];
        }
        return buckets;
    }

    @Override
    public T getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        QuantilesUtil.checkNormalizedRankBounds(rank);
        int index = this.getQuantileIndex(rank, searchCrit);
        return this.quantiles[index];
    }

    private int getQuantileIndex(double rank, QuantileSearchCriteria searchCrit) {
        InequalitySearch crit;
        int len = this.cumWeights.length;
        double naturalRank = QuantilesUtil.getNaturalRank(rank, this.totalN, searchCrit);
        int index = InequalitySearch.find(this.cumWeights, 0, len - 1, naturalRank, crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.GE : InequalitySearch.GT);
        if (index == -1) {
            return len - 1;
        }
        return index;
    }

    public T[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        int len = ranks.length;
        Object[] quants = (Object[])Array.newInstance(this.clazz, len);
        for (int i = 0; i < len; ++i) {
            quants[i] = this.getQuantile(ranks[i], searchCrit);
        }
        return quants;
    }

    @Override
    public T[] getQuantiles() {
        Object[] quants = (Object[])Array.newInstance(this.minItem.getClass(), this.quantiles.length);
        System.arraycopy(this.quantiles, 0, quants, 0, this.quantiles.length);
        return quants;
    }

    @Override
    public double getRank(T quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        int len = this.quantiles.length;
        GenericInequalitySearch.Inequality crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? GenericInequalitySearch.Inequality.LE : GenericInequalitySearch.Inequality.LT;
        int index = GenericInequalitySearch.find(this.quantiles, 0, len - 1, quantile, crit, this.comparator);
        if (index == -1) {
            return 0.0;
        }
        return (double)this.cumWeights[index] / (double)this.totalN;
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public GenericSortedViewIterator<T> iterator() {
        return new GenericSortedViewIterator<T>(this.quantiles, this.cumWeights);
    }
}

