/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllDoublesHelper;
import org.apache.datasketches.kll.KllDoublesSketchIterator;
import org.apache.datasketches.kll.KllDoublesSketchSortedView;
import org.apache.datasketches.kll.KllHeapDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.DoublesSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesDoublesAPI;
import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIterator;

public abstract class KllDoublesSketch
extends KllSketch
implements QuantilesDoublesAPI {
    private KllDoublesSketchSortedView kllDoublesSV = null;
    static final int ITEM_BYTES = 8;

    KllDoublesSketch(KllSketch.SketchStructure sketchStructure) {
        super(KllSketch.SketchType.DOUBLES_SKETCH, sketchStructure);
    }

    public static KllDoublesSketch newHeapInstance() {
        return KllDoublesSketch.newHeapInstance(200);
    }

    public static KllDoublesSketch newHeapInstance(int k) {
        return new KllHeapDoublesSketch(k, 8);
    }

    public static KllDoublesSketch newDirectInstance(WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        return KllDoublesSketch.newDirectInstance(200, dstMem, memReqSvr);
    }

    public static KllDoublesSketch newDirectInstance(int k, WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(dstMem, "Parameter 'dstMem' must not be null");
        Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
        return KllDirectDoublesSketch.newDirectUpdatableInstance(k, 8, dstMem, memReqSvr);
    }

    public static KllDoublesSketch heapify(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        return KllHeapDoublesSketch.heapifyImpl(srcMem);
    }

    public static KllDoublesSketch wrap(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem, KllSketch.SketchType.DOUBLES_SKETCH, null);
        if (memVal.sketchStructure == KllSketch.SketchStructure.UPDATABLE) {
            DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
            return new KllDirectDoublesSketch(memVal.sketchStructure, (WritableMemory)srcMem, (MemoryRequestServer)memReqSvr, memVal);
        }
        return new KllDirectDoublesSketch.KllDirectCompactDoublesSketch(memVal.sketchStructure, srcMem, memVal);
    }

    public static KllDoublesSketch writableWrap(WritableMemory srcMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)srcMem, KllSketch.SketchType.DOUBLES_SKETCH);
        if (memVal.sketchStructure == KllSketch.SketchStructure.UPDATABLE) {
            return new KllDirectDoublesSketch(KllSketch.SketchStructure.UPDATABLE, srcMem, memReqSvr, memVal);
        }
        return new KllDirectDoublesSketch.KllDirectCompactDoublesSketch(memVal.sketchStructure, (Memory)srcMem, memVal);
    }

    @Override
    public double[] getCDF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllDoublesSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public double[] getPMF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllDoublesSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public double getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllDoublesSV.getQuantile(rank, searchCrit);
    }

    @Override
    public double[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = ranks.length;
        double[] quantiles = new double[len];
        for (int i = 0; i < len; ++i) {
            quantiles[i] = this.kllDoublesSV.getQuantile(ranks[i], searchCrit);
        }
        return quantiles;
    }

    @Override
    public double getQuantileLowerBound(double rank) {
        return this.getQuantile(Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getQuantileUpperBound(double rank) {
        return this.getQuantile(Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getRank(double quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllDoublesSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double[] getRanks(double[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.kllDoublesSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="OK in this case.")
    public DoublesSortedView getSortedView() {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllDoublesSV;
    }

    @Override
    public QuantilesDoublesSketchIterator iterator() {
        return new KllDoublesSketchIterator(this.getDoubleItemsArray(), this.getLevelsArray(KllSketch.SketchStructure.UPDATABLE), this.getNumLevels());
    }

    @Override
    public final void merge(KllSketch other) {
        if (this.readOnly || this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllDoublesSketch othDblSk = (KllDoublesSketch)other;
        if (othDblSk.isEmpty()) {
            return;
        }
        KllDoublesHelper.mergeDoubleImpl(this, othDblSk);
        this.kllDoublesSV = null;
    }

    @Override
    public final void reset() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int k = this.getK();
        this.setN(0L);
        this.setMinK(k);
        this.setNumLevels(1);
        this.setLevelZeroSorted(false);
        this.setLevelsArray(new int[]{k, k});
        this.setMinItem(Double.NaN);
        this.setMaxItem(Double.NaN);
        this.setDoubleItemsArray(new double[k]);
        this.kllDoublesSV = null;
    }

    @Override
    public byte[] toByteArray() {
        return KllHelper.toByteArray(this, false);
    }

    @Override
    public void update(double item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllDoublesHelper.updateDouble(this, item);
        this.kllDoublesSV = null;
    }

    abstract double[] getDoubleItemsArray();

    abstract double[] getDoubleRetainedItemsArray();

    abstract double getDoubleSingleItem();

    @Override
    abstract byte[] getMinMaxByteArr();

    @Override
    int getMinMaxSizeBytes() {
        return 16;
    }

    @Override
    abstract byte[] getRetainedItemsByteArr();

    @Override
    int getRetainedItemsSizeBytes() {
        return this.getNumRetained() * 8;
    }

    @Override
    ArrayOfItemsSerDe<?> getSerDe() {
        return null;
    }

    @Override
    final byte[] getSingleItemByteArr() {
        byte[] bytes = new byte[8];
        ByteArrayUtil.putDoubleLE(bytes, 0, this.getDoubleSingleItem());
        return bytes;
    }

    @Override
    int getSingleItemSizeBytes() {
        return 8;
    }

    @Override
    abstract byte[] getTotalItemsByteArr();

    @Override
    int getTotalItemsNumBytes() {
        return this.levelsArr[this.getNumLevels()] * 8;
    }

    private final void refreshSortedView() {
        this.kllDoublesSV = this.kllDoublesSV == null ? new KllDoublesSketchSortedView(this) : this.kllDoublesSV;
    }

    abstract void setDoubleItemsArray(double[] var1);

    abstract void setDoubleItemsArrayAt(int var1, double var2);

    abstract void setMaxItem(double var1);

    abstract void setMinItem(double var1);
}

