/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesFloatsSketchIterator;
import org.apache.datasketches.req.BaseReqSketch;
import org.apache.datasketches.req.FloatBuffer;
import org.apache.datasketches.req.ReqCompactor;
import org.apache.datasketches.req.ReqDebug;
import org.apache.datasketches.req.ReqSerDe;
import org.apache.datasketches.req.ReqSketchBuilder;
import org.apache.datasketches.req.ReqSketchIterator;
import org.apache.datasketches.req.ReqSketchSortedView;

public final class ReqSketch
extends BaseReqSketch {
    private static final String LS = System.getProperty("line.separator");
    static final byte MIN_K = 4;
    static final byte NOM_CAP_MULT = 2;
    private final int k;
    private final boolean hra;
    private long totalN = 0L;
    private float minItem = Float.NaN;
    private float maxItem = Float.NaN;
    private int retItems = 0;
    private int maxNomSize = 0;
    private ReqSketchSortedView reqSV = null;
    private List<ReqCompactor> compactors = new ArrayList<ReqCompactor>();
    private ReqDebug reqDebug = null;
    private final CompactorReturn cReturn = new CompactorReturn();
    private final Random rand;

    ReqSketch(int k, boolean hra, long totalN, float minItem, float maxItem, List<ReqCompactor> compactors) {
        ReqSketch.checkK(k);
        this.k = k;
        this.hra = hra;
        this.totalN = totalN;
        this.minItem = minItem;
        this.maxItem = maxItem;
        this.compactors = compactors;
        this.rand = new Random();
    }

    ReqSketch(int k, boolean highRankAccuracy, ReqDebug reqDebug) {
        ReqSketch.checkK(k);
        this.k = k;
        this.hra = highRankAccuracy;
        this.reqDebug = reqDebug;
        this.rand = reqDebug == null ? new Random() : new Random(1L);
        this.grow();
    }

    ReqSketch(ReqSketch other) {
        this.k = other.k;
        this.hra = other.hra;
        this.totalN = other.totalN;
        this.retItems = other.retItems;
        this.maxNomSize = other.maxNomSize;
        this.minItem = other.minItem;
        this.maxItem = other.maxItem;
        this.reqDebug = other.reqDebug;
        this.reqSV = null;
        this.rand = this.reqDebug == null ? new Random() : new Random(1L);
        for (int i = 0; i < other.getNumLevels(); ++i) {
            this.compactors.add(new ReqCompactor(other.compactors.get(i)));
        }
    }

    public static final ReqSketchBuilder builder() {
        return new ReqSketchBuilder();
    }

    public static ReqSketch heapify(Memory mem) {
        return ReqSerDe.heapify(mem);
    }

    @Override
    public int getK() {
        return this.k;
    }

    static void validateSplits(float[] splits) {
        int len = splits.length;
        for (int i = 0; i < len; ++i) {
            float v = splits[i];
            if (!Float.isFinite(v)) {
                throw new SketchesArgumentException("Numbers must be finite");
            }
            if (i >= len - 1 || !(v >= splits[i + 1])) continue;
            throw new SketchesArgumentException("Numbers must be unique and monotonically increasing");
        }
    }

    @Override
    public double[] getCDF(float[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        return this.reqSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public boolean getHighRankAccuracyMode() {
        return this.hra;
    }

    @Override
    public float getMaxItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        return this.maxItem;
    }

    @Override
    public float getMinItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        return this.minItem;
    }

    @Override
    public long getN() {
        return this.totalN;
    }

    @Override
    public double[] getPMF(float[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        return this.reqSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public float getQuantile(double normRank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        if (normRank < 0.0 || normRank > 1.0) {
            throw new SketchesArgumentException("Normalized rank must be in the range [0.0, 1.0]: " + normRank);
        }
        this.refreshSortedView();
        return this.reqSV.getQuantile(normRank, searchCrit);
    }

    @Override
    public float[] getQuantiles(double[] normRanks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        int len = normRanks.length;
        float[] qArr = new float[len];
        for (int i = 0; i < len; ++i) {
            qArr[i] = this.reqSV.getQuantile(normRanks[i], searchCrit);
        }
        return qArr;
    }

    @Override
    public float getQuantileLowerBound(double rank) {
        return this.getQuantile(this.getRankLowerBound(rank, 2), QuantileSearchCriteria.INCLUSIVE);
    }

    @Override
    public float getQuantileLowerBound(double rank, int numStdDev) {
        return this.getQuantile(this.getRankLowerBound(rank, numStdDev), QuantileSearchCriteria.INCLUSIVE);
    }

    @Override
    public float getQuantileUpperBound(double rank) {
        return this.getQuantile(this.getRankUpperBound(rank, 2), QuantileSearchCriteria.INCLUSIVE);
    }

    @Override
    public float getQuantileUpperBound(double rank, int numStdDev) {
        return this.getQuantile(this.getRankUpperBound(rank, numStdDev), QuantileSearchCriteria.INCLUSIVE);
    }

    @Override
    public double getRank(float quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        return this.reqSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return ReqSketch.getRankLB(this.k, this.getNumLevels(), rank, 2, this.hra, this.getN());
    }

    @Override
    public double getRankLowerBound(double rank, int numStdDev) {
        return ReqSketch.getRankLB(this.k, this.getNumLevels(), rank, numStdDev, this.hra, this.getN());
    }

    @Override
    public double[] getRanks(float[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        int numQuantiles = quantiles.length;
        double[] retArr = new double[numQuantiles];
        for (int i = 0; i < numQuantiles; ++i) {
            retArr[i] = this.reqSV.getRank(quantiles[i], searchCrit);
        }
        return retArr;
    }

    @Override
    public double getRankUpperBound(double rank) {
        return ReqSketch.getRankUB(this.k, this.getNumLevels(), rank, 2, this.hra, this.getN());
    }

    @Override
    public double getRankUpperBound(double rank, int numStdDev) {
        return ReqSketch.getRankUB(this.k, this.getNumLevels(), rank, numStdDev, this.hra, this.getN());
    }

    @Override
    public int getNumRetained() {
        return this.retItems;
    }

    @Override
    public int getSerializedSizeBytes() {
        ReqSerDe.SerDeFormat serDeFormat = ReqSerDe.getSerFormat(this);
        return ReqSerDe.getSerBytes(this, serDeFormat);
    }

    @Override
    public FloatsSortedView getSortedView() {
        this.refreshSortedView();
        return this.reqSV;
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public boolean isEstimationMode() {
        return this.getNumLevels() > 1;
    }

    @Override
    public QuantilesFloatsSketchIterator iterator() {
        return new ReqSketchIterator(this);
    }

    @Override
    public ReqSketch merge(ReqSketch other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        if (other.hra != this.hra) {
            throw new SketchesArgumentException("Both sketches must have the same HighRankAccuracy setting.");
        }
        this.totalN += other.totalN;
        if (Float.isNaN(this.minItem) || other.minItem < this.minItem) {
            this.minItem = other.minItem;
        }
        if (Float.isNaN(this.maxItem) || other.maxItem > this.maxItem) {
            this.maxItem = other.maxItem;
        }
        while (this.getNumLevels() < other.getNumLevels()) {
            this.grow();
        }
        for (int i = 0; i < other.getNumLevels(); ++i) {
            this.compactors.get(i).merge(other.compactors.get(i));
        }
        this.maxNomSize = this.computeMaxNomSize();
        this.retItems = this.computeTotalRetainedItems();
        if (this.retItems >= this.maxNomSize) {
            this.compress();
        }
        assert (this.retItems < this.maxNomSize);
        this.reqSV = null;
        return this;
    }

    @Override
    public void reset() {
        this.totalN = 0L;
        this.retItems = 0;
        this.maxNomSize = 0;
        this.minItem = Float.NaN;
        this.maxItem = Float.NaN;
        this.reqSV = null;
        this.compactors = new ArrayList<ReqCompactor>();
        this.grow();
    }

    @Override
    public byte[] toByteArray() {
        return ReqSerDe.toByteArray(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("**********Relative Error Quantiles Sketch Summary**********").append(LS);
        sb.append("  K               : " + this.k).append(LS);
        sb.append("  N               : " + this.totalN).append(LS);
        sb.append("  Retained Items  : " + this.retItems).append(LS);
        sb.append("  Min Item        : " + this.minItem).append(LS);
        sb.append("  Max Item        : " + this.maxItem).append(LS);
        sb.append("  Estimation Mode : " + this.isEstimationMode()).append(LS);
        sb.append("  High Rank Acc   : " + this.hra).append(LS);
        sb.append("  Levels          : " + this.compactors.size()).append(LS);
        sb.append("************************End Summary************************").append(LS);
        return sb.toString();
    }

    @Override
    public void update(float item) {
        if (Float.isNaN(item)) {
            return;
        }
        if (this.isEmpty()) {
            this.minItem = item;
            this.maxItem = item;
        } else {
            if (item < this.minItem) {
                this.minItem = item;
            }
            if (item > this.maxItem) {
                this.maxItem = item;
            }
        }
        FloatBuffer buf = this.compactors.get(0).getBuffer();
        buf.append(item);
        ++this.retItems;
        ++this.totalN;
        if (this.retItems >= this.maxNomSize) {
            buf.sort();
            this.compress();
        }
        this.reqSV = null;
    }

    @Override
    public String viewCompactorDetail(String fmt, boolean allData) {
        StringBuilder sb = new StringBuilder();
        sb.append("*********Relative Error Quantiles Compactor Detail*********").append(LS);
        sb.append("Compactor Detail: Ret Items: ").append(this.getNumRetained()).append("  N: ").append(this.getN());
        sb.append(LS);
        for (int i = 0; i < this.getNumLevels(); ++i) {
            ReqCompactor c = this.compactors.get(i);
            sb.append(c.toListPrefix()).append(LS);
            if (!allData) continue;
            sb.append(c.getBuffer().toHorizList(fmt, 20)).append(LS);
        }
        sb.append("************************End Detail*************************").append(LS);
        return sb.toString();
    }

    int computeMaxNomSize() {
        int cap = 0;
        for (ReqCompactor c : this.compactors) {
            cap += c.getNomCapacity();
        }
        return cap;
    }

    int computeTotalRetainedItems() {
        int count = 0;
        for (ReqCompactor c : this.compactors) {
            count += c.getBuffer().getCount();
        }
        return count;
    }

    List<ReqCompactor> getCompactors() {
        return this.compactors;
    }

    int getMaxNomSize() {
        return this.maxNomSize;
    }

    int getNumLevels() {
        return this.compactors.size();
    }

    void setMaxNomSize(int maxNomSize) {
        this.maxNomSize = maxNomSize;
    }

    void setRetainedItems(int retItems) {
        this.retItems = retItems;
    }

    private static void checkK(int k) {
        if ((k & 1) > 0 || k < 4 || k > 1024) {
            throw new SketchesArgumentException("<i>K</i> must be even and in the range [4, 1024]: " + k);
        }
    }

    private void compress() {
        if (this.reqDebug != null) {
            this.reqDebug.emitStartCompress();
        }
        for (int h = 0; h < this.compactors.size(); ++h) {
            int compNomCap;
            ReqCompactor c = this.compactors.get(h);
            int compRetItems = c.getBuffer().getCount();
            if (compRetItems < (compNomCap = c.getNomCapacity())) continue;
            if (h + 1 >= this.getNumLevels()) {
                if (this.reqDebug != null) {
                    this.reqDebug.emitMustAddCompactor();
                }
                this.grow();
            }
            FloatBuffer promoted = c.compact(this.cReturn, this.rand);
            this.compactors.get(h + 1).getBuffer().mergeSortIn(promoted);
            this.retItems += this.cReturn.deltaRetItems;
            this.maxNomSize += this.cReturn.deltaNomSize;
        }
        this.reqSV = null;
        if (this.reqDebug != null) {
            this.reqDebug.emitCompressDone();
        }
    }

    private void grow() {
        byte lgWeight = (byte)this.getNumLevels();
        if (lgWeight == 0 && this.reqDebug != null) {
            this.reqDebug.emitStart(this);
        }
        this.compactors.add(new ReqCompactor(lgWeight, this.hra, this.k, this.reqDebug));
        this.maxNomSize = this.computeMaxNomSize();
        if (this.reqDebug != null) {
            this.reqDebug.emitNewCompactor(lgWeight);
        }
    }

    private final void refreshSortedView() {
        this.reqSV = this.reqSV == null ? new ReqSketchSortedView(this) : this.reqSV;
    }

    static class CompactorReturn {
        int deltaRetItems;
        int deltaNomSize;

        CompactorReturn() {
        }
    }
}

