/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.kll.KllDirectFloatsSketch;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

class KllDirectCompactFloatsSketch
extends KllDirectFloatsSketch {
    KllDirectCompactFloatsSketch(Memory srcMem, KllMemoryValidate memVal) {
        super((WritableMemory)srcMem, null, memVal);
    }

    @Override
    public long getN() {
        if (KllPreambleUtil.getMemoryEmptyFlag((Memory)this.wmem)) {
            return 0L;
        }
        if (KllPreambleUtil.getMemorySingleItemFlag((Memory)this.wmem)) {
            return 1L;
        }
        return KllPreambleUtil.getMemoryN((Memory)this.wmem);
    }

    @Override
    public byte[] toByteArray() {
        int bytes = (int)this.wmem.getCapacity();
        byte[] byteArr = new byte[bytes];
        this.wmem.getByteArray(0L, byteArr, 0, bytes);
        return byteArr;
    }

    @Override
    float[] getFloatItemsArray() {
        int k = this.getK();
        if (this.isEmpty()) {
            return new float[k];
        }
        if (this.isSingleItem()) {
            float[] itemsArr = new float[k];
            itemsArr[k - 1] = this.wmem.getFloat(8L);
            return itemsArr;
        }
        int capacityItems = this.levelsArr[this.getNumLevels()];
        float[] itemsArr = new float[capacityItems];
        int levelsBytes = (this.levelsArr.length - 1) * 4;
        int offset = 20 + levelsBytes + 8;
        int shift = this.levelsArr[0];
        this.wmem.getFloatArray((long)offset, itemsArr, shift, capacityItems - shift);
        return itemsArr;
    }

    @Override
    float getFloatSingleItem() {
        if (!this.isSingleItem()) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.NOT_SINGLE_ITEM);
        }
        return this.wmem.getFloat(8L);
    }

    @Override
    float getMaxFloatItem() {
        if (this.isEmpty()) {
            return Float.NaN;
        }
        if (this.isSingleItem()) {
            return this.getFloatSingleItem();
        }
        int offset = 20 + (this.getLevelsArray().length - 1) * 4 + 4;
        return this.wmem.getFloat((long)offset);
    }

    @Override
    float getMinFloatItem() {
        if (this.isEmpty()) {
            return Float.NaN;
        }
        if (this.isSingleItem()) {
            return this.getFloatSingleItem();
        }
        int offset = 20 + (this.getLevelsArray().length - 1) * 4;
        return this.wmem.getFloat((long)offset);
    }
}

