/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.datasketches.sampling.VarOptItemsSketch;

public class VarOptItemsSamples<T>
implements Iterable<WeightedSample> {
    final VarOptItemsSketch<T> sketch_;
    VarOptItemsSketch.Result sampleLists;
    final long n_;
    final int h_;
    final double rWeight_;

    VarOptItemsSamples(VarOptItemsSketch<T> sketch) {
        this.sketch_ = sketch;
        this.n_ = sketch.getN();
        this.h_ = sketch.getHRegionCount();
        this.rWeight_ = sketch.getTau();
    }

    @Override
    public Iterator<WeightedSample> iterator() {
        return new VarOptItemsIterator();
    }

    Iterator<WeightedSample> getHIterator() {
        return new VarOptItemsIterator(false);
    }

    Iterator<WeightedSample> getRIterator() {
        return new VarOptItemsIterator(true);
    }

    Iterator<WeightedSample> getWeightCorrRIter() {
        return new WeightCorrectingRRegionIterator();
    }

    public void setClass(Class<?> clazz) {
        if (this.sampleLists == null) {
            this.sampleLists = this.sketch_.getSamplesAsArrays(clazz);
        }
    }

    public int getNumSamples() {
        this.loadArrays();
        return this.sampleLists == null ? 0 : this.sampleLists.weights.length;
    }

    public T[] items() {
        this.loadArrays();
        return this.sampleLists == null ? null : this.sampleLists.items;
    }

    public T items(int i) {
        this.loadArrays();
        return this.sampleLists == null ? null : (T)this.sampleLists.items[i];
    }

    public double[] weights() {
        this.loadArrays();
        return this.sampleLists == null ? null : this.sampleLists.weights;
    }

    public double weights(int i) {
        this.loadArrays();
        return this.sampleLists == null ? Double.NaN : this.sampleLists.weights[i];
    }

    private void loadArrays() {
        if (this.sampleLists == null) {
            this.sampleLists = this.sketch_.getSamplesAsArrays();
        }
    }

    public class VarOptItemsIterator
    implements Iterator<WeightedSample> {
        int currIdx_;
        int finalIdx_;

        VarOptItemsIterator() {
            this.currIdx_ = VarOptItemsSamples.this.h_ == 0 ? 1 : 0;
            int k = VarOptItemsSamples.this.sketch_.getK();
            this.finalIdx_ = (int)(VarOptItemsSamples.this.n_ <= (long)k ? VarOptItemsSamples.this.n_ - 1L : (long)k);
        }

        VarOptItemsIterator(boolean useRRegion) {
            if (useRRegion) {
                this.currIdx_ = VarOptItemsSamples.this.h_ + 1;
                this.finalIdx_ = VarOptItemsSamples.this.sketch_.getNumSamples();
            } else {
                this.currIdx_ = 0;
                this.finalIdx_ = VarOptItemsSamples.this.h_ - 1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.currIdx_ <= this.finalIdx_;
        }

        @Override
        public WeightedSample next() {
            if (VarOptItemsSamples.this.n_ != VarOptItemsSamples.this.sketch_.getN()) {
                throw new ConcurrentModificationException();
            }
            if (this.currIdx_ > this.finalIdx_) {
                throw new NoSuchElementException();
            }
            int tgt = this.currIdx_++;
            if (this.currIdx_ == VarOptItemsSamples.this.h_ && (long)VarOptItemsSamples.this.h_ != VarOptItemsSamples.this.n_) {
                ++this.currIdx_;
            }
            return new WeightedSample(tgt);
        }
    }

    class WeightCorrectingRRegionIterator
    extends VarOptItemsIterator {
        private double cumWeight;

        WeightCorrectingRRegionIterator() {
            super(true);
            this.cumWeight = 0.0;
        }

        @Override
        public WeightedSample next() {
            WeightedSample sample;
            int tgt;
            if (VarOptItemsSamples.this.n_ != VarOptItemsSamples.this.sketch_.getN()) {
                throw new ConcurrentModificationException();
            }
            if (this.currIdx_ > this.finalIdx_) {
                throw new NoSuchElementException();
            }
            if ((tgt = this.currIdx_++) == this.finalIdx_) {
                sample = new WeightedSample(tgt, VarOptItemsSamples.this.sketch_.getTotalWtR() - this.cumWeight);
            } else {
                sample = new WeightedSample(tgt);
                this.cumWeight += VarOptItemsSamples.this.rWeight_;
            }
            return sample;
        }
    }

    public final class WeightedSample {
        private final int idx_;
        private double adjustedWeight_;

        WeightedSample(int i) {
            this.idx_ = i;
            this.adjustedWeight_ = Double.NaN;
        }

        WeightedSample(int i, double adjustedWeight) {
            this.idx_ = i;
            this.adjustedWeight_ = adjustedWeight;
        }

        public T getItem() {
            return VarOptItemsSamples.this.sketch_.getItem(this.idx_);
        }

        public double getWeight() {
            if (this.idx_ > VarOptItemsSamples.this.h_) {
                return Double.isNaN(this.adjustedWeight_) ? VarOptItemsSamples.this.rWeight_ : this.adjustedWeight_;
            }
            return VarOptItemsSamples.this.sketch_.getWeight(this.idx_);
        }

        boolean getMark() {
            return VarOptItemsSamples.this.sketch_.getMark(this.idx_);
        }
    }
}

