/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Arrays;
import java.util.Random;
import org.apache.datasketches.SketchesArgumentException;

class KllHelper {
    private static final Random random = new Random();
    private static final long[] powersOfThree = new long[]{1L, 3L, 9L, 27L, 81L, 243L, 729L, 2187L, 6561L, 19683L, 59049L, 177147L, 531441L, 1594323L, 4782969L, 14348907L, 43046721L, 129140163L, 387420489L, 1162261467L, 3486784401L, 10460353203L, 31381059609L, 94143178827L, 282429536481L, 847288609443L, 2541865828329L, 7625597484987L, 22876792454961L, 68630377364883L, 205891132094649L};

    KllHelper() {
    }

    static boolean isEven(int value) {
        return (value & 1) == 0;
    }

    static boolean isOdd(int value) {
        return (value & 1) > 0;
    }

    static int floorOfLog2OfFraction(long numer, long denom) {
        if (denom > numer) {
            return 0;
        }
        int count = 0;
        while ((denom <<= 1) <= numer) {
            ++count;
        }
        return count;
    }

    static final void validateValues(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (Float.isNaN(values[i])) {
                throw new SketchesArgumentException("Values must not be NaN");
            }
            if (i >= values.length - 1 || !(values[i] >= values[i + 1])) continue;
            throw new SketchesArgumentException("Values must be unique and monotonically increasing");
        }
    }

    static int[] growIntArray(int[] oldArr, int newLen) {
        int oldLen = oldArr.length;
        assert (newLen > oldLen);
        int[] newArr = new int[newLen];
        System.arraycopy(oldArr, 0, newArr, 0, oldLen);
        return newArr;
    }

    static int ubOnNumLevels(long n) {
        if (n == 0L) {
            return 1;
        }
        return 1 + KllHelper.floorOfLog2OfFraction(n, 1L);
    }

    static int computeTotalCapacity(int k, int m, int numLevels) {
        int total = 0;
        for (int h = 0; h < numLevels; ++h) {
            total += KllHelper.levelCapacity(k, numLevels, h, m);
        }
        return total;
    }

    static int levelCapacity(int k, int numLevels, int height, int minWid) {
        assert (height >= 0);
        assert (height < numLevels);
        int depth = numLevels - height - 1;
        return Math.max(minWid, KllHelper.intCapAux(k, depth));
    }

    private static int intCapAux(int k, int depth) {
        assert (k <= 0x40000000);
        assert (depth <= 60);
        if (depth <= 30) {
            return KllHelper.intCapAuxAux(k, depth);
        }
        int half = depth / 2;
        int rest = depth - half;
        int tmp = KllHelper.intCapAuxAux(k, half);
        return KllHelper.intCapAuxAux(tmp, rest);
    }

    private static int intCapAuxAux(int k, int depth) {
        assert (k <= 0x40000000);
        assert (depth <= 30);
        int twok = k << 1;
        int tmp = (int)(((long)twok << depth) / powersOfThree[depth]);
        int result = tmp + 1 >> 1;
        assert (result <= k);
        return result;
    }

    static long sumTheSampleWeights(int num_levels, int[] levels) {
        long total = 0L;
        long weight = 1L;
        for (int lvl = 0; lvl < num_levels; ++lvl) {
            total += weight * (long)(levels[lvl + 1] - levels[lvl]);
            weight *= 2L;
        }
        return total;
    }

    static void mergeSortedArrays(float[] bufA, int startA, int lenA, float[] bufB, int startB, int lenB, float[] bufC, int startC) {
        int lenC = lenA + lenB;
        int limA = startA + lenA;
        int limB = startB + lenB;
        int limC = startC + lenC;
        int a = startA;
        int b = startB;
        for (int c = startC; c < limC; ++c) {
            if (a == limA) {
                bufC[c] = bufB[b];
                ++b;
                continue;
            }
            if (b == limB) {
                bufC[c] = bufA[a];
                ++a;
                continue;
            }
            if (bufA[a] < bufB[b]) {
                bufC[c] = bufA[a];
                ++a;
                continue;
            }
            bufC[c] = bufB[b];
            ++b;
        }
        assert (a == limA);
        assert (b == limB);
    }

    static int[] generalCompress(int k, int m, int numLevelsIn, float[] inBuf, int[] inLevels, float[] outBuf, int[] outLevels, boolean isLevelZeroSorted) {
        assert (numLevelsIn > 0);
        int numLevels = numLevelsIn;
        int currentItemCount = inLevels[numLevels] - inLevels[0];
        int targetItemCount = KllHelper.computeTotalCapacity(k, m, numLevels);
        boolean doneYet = false;
        outLevels[0] = 0;
        int curLevel = -1;
        while (!doneYet) {
            if (++curLevel == numLevels - 1) {
                inLevels[curLevel + 2] = inLevels[curLevel + 1];
            }
            int rawBeg = inLevels[curLevel];
            int rawLim = inLevels[curLevel + 1];
            int rawPop = rawLim - rawBeg;
            if (currentItemCount < targetItemCount || rawPop < KllHelper.levelCapacity(k, numLevels, curLevel, m)) {
                assert (rawBeg >= outLevels[curLevel]);
                System.arraycopy(inBuf, rawBeg, outBuf, outLevels[curLevel], rawPop);
                outLevels[curLevel + 1] = outLevels[curLevel] + rawPop;
            } else {
                int popAbove = inLevels[curLevel + 2] - rawLim;
                boolean oddPop = KllHelper.isOdd(rawPop);
                int adjBeg = oddPop ? 1 + rawBeg : rawBeg;
                int adjPop = oddPop ? rawPop - 1 : rawPop;
                int halfAdjPop = adjPop / 2;
                if (oddPop) {
                    outBuf[outLevels[curLevel]] = inBuf[rawBeg];
                    outLevels[curLevel + 1] = outLevels[curLevel] + 1;
                } else {
                    outLevels[curLevel + 1] = outLevels[curLevel];
                }
                if (curLevel == 0 && !isLevelZeroSorted) {
                    Arrays.sort(inBuf, adjBeg, adjBeg + adjPop);
                }
                if (popAbove == 0) {
                    KllHelper.randomlyHalveUp(inBuf, adjBeg, adjPop);
                } else {
                    KllHelper.randomlyHalveDown(inBuf, adjBeg, adjPop);
                    KllHelper.mergeSortedArrays(inBuf, adjBeg, halfAdjPop, inBuf, rawLim, popAbove, inBuf, adjBeg + halfAdjPop);
                }
                currentItemCount -= halfAdjPop;
                inLevels[curLevel + 1] = inLevels[curLevel + 1] - halfAdjPop;
                if (curLevel == numLevels - 1) {
                    targetItemCount += KllHelper.levelCapacity(k, ++numLevels, 0, m);
                }
            }
            if (curLevel != numLevels - 1) continue;
            doneYet = true;
        }
        assert (outLevels[numLevels] - outLevels[0] == currentItemCount);
        return new int[]{numLevels, targetItemCount, currentItemCount};
    }

    static void randomlyHalveDown(float[] buf, int start, int length) {
        assert (KllHelper.isEven(length));
        int half_length = length / 2;
        int offset = random.nextInt(2);
        int j = start + offset;
        for (int i = start; i < start + half_length; ++i) {
            buf[i] = buf[j];
            j += 2;
        }
    }

    static void randomlyHalveUp(float[] buf, int start, int length) {
        assert (KllHelper.isEven(length));
        int half_length = length / 2;
        int offset = random.nextInt(2);
        int j = start + length - 1 - offset;
        for (int i = start + length - 1; i >= start + half_length; --i) {
            buf[i] = buf[j];
            j -= 2;
        }
    }
}

