/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

import org.apache.datasketches.BoundsOnBinomialProportions;
import org.apache.datasketches.SketchesArgumentException;

public final class BoundsOnRatiosInSampledSets {
    private static final double NUM_STD_DEVS = 2.0;

    private BoundsOnRatiosInSampledSets() {
    }

    public static double getLowerBoundForBoverA(long a, long b, double f) {
        BoundsOnRatiosInSampledSets.checkInputs(a, b, f);
        if (a == 0L) {
            return 0.0;
        }
        if (f == 1.0) {
            return (double)b / (double)a;
        }
        return BoundsOnBinomialProportions.approximateLowerBoundOnP(a, b, 2.0 * BoundsOnRatiosInSampledSets.hackyAdjuster(f));
    }

    public static double getUpperBoundForBoverA(long a, long b, double f) {
        BoundsOnRatiosInSampledSets.checkInputs(a, b, f);
        if (a == 0L) {
            return 1.0;
        }
        if (f == 1.0) {
            return (double)b / (double)a;
        }
        return BoundsOnBinomialProportions.approximateUpperBoundOnP(a, b, 2.0 * BoundsOnRatiosInSampledSets.hackyAdjuster(f));
    }

    public static double getEstimateOfBoverA(long a, long b) {
        BoundsOnRatiosInSampledSets.checkInputs(a, b, 0.3);
        if (a == 0L) {
            return 0.5;
        }
        return (double)b / (double)a;
    }

    private static double hackyAdjuster(double f) {
        double tmp = Math.sqrt(1.0 - f);
        return f <= 0.5 ? tmp : tmp + 0.01 * (f - 0.5);
    }

    static void checkInputs(long a, long b, double f) {
        if ((a - b | a | b) < 0L) {
            throw new SketchesArgumentException("a must be >= b and neither a nor b can be < 0: a = " + a + ", b = " + b);
        }
        if (f > 1.0 || f <= 0.0) {
            throw new SketchesArgumentException("Required: ((f <= 1.0) && (f > 0.0)): " + f);
        }
    }

    public static double getEstimateOfA(long a, double f) {
        BoundsOnRatiosInSampledSets.checkInputs(a, 1L, f);
        return (double)a / f;
    }

    public static double getEstimateOfB(long b, double f) {
        BoundsOnRatiosInSampledSets.checkInputs(b + 1L, b, f);
        return (double)b / f;
    }
}

