/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import java.nio.ByteOrder;
import org.apache.datasketches.ByteArrayUtil;
import org.apache.datasketches.Family;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.QuickSelect;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.DeserializeResult;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Util;

class QuickSelectSketch<S extends Summary>
extends Sketch<S> {
    private static final byte serialVersionUID = 2;
    static final int DEFAULT_LG_RESIZE_FACTOR = ResizeFactor.X8.lg();
    private final int nomEntries_;
    private int lgCurrentCapacity_;
    private final int lgResizeFactor_;
    private int count_;
    private final SummaryFactory<S> summaryFactory_;
    private final float samplingProbability_;
    private int rebuildThreshold_;

    QuickSelectSketch(int nomEntries, SummaryFactory<S> summaryFactory) {
        this(nomEntries, DEFAULT_LG_RESIZE_FACTOR, summaryFactory);
    }

    QuickSelectSketch(int nomEntries, int lgResizeFactor, SummaryFactory<S> summaryFactory) {
        this(nomEntries, lgResizeFactor, 1.0f, summaryFactory);
    }

    QuickSelectSketch(int nomEntries, int lgResizeFactor, float samplingProbability, SummaryFactory<S> summaryFactory) {
        this(nomEntries, lgResizeFactor, samplingProbability, summaryFactory, Util.getStartingCapacity(nomEntries, lgResizeFactor));
    }

    QuickSelectSketch(int nomEntries, int lgResizeFactor, float samplingProbability, SummaryFactory<S> summaryFactory, int startingSize) {
        this.nomEntries_ = org.apache.datasketches.Util.ceilingPowerOf2(nomEntries);
        this.lgResizeFactor_ = lgResizeFactor;
        this.samplingProbability_ = samplingProbability;
        this.summaryFactory_ = summaryFactory;
        this.theta_ = (long)(9.223372036854776E18 * (double)samplingProbability);
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingSize);
        this.keys_ = new long[startingSize];
        this.summaries_ = null;
        this.setRebuildThreshold();
    }

    QuickSelectSketch(Memory mem, SummaryDeserializer<S> deserializer, SummaryFactory<S> summaryFactory) {
        boolean hasEntries;
        boolean isThetaIncluded;
        boolean isBigEndian;
        this.summaryFactory_ = summaryFactory;
        int offset = 0;
        byte preambleLongs = mem.getByte((long)offset++);
        byte version = mem.getByte((long)offset++);
        byte familyId = mem.getByte((long)offset++);
        SerializerDeserializer.validateFamily(familyId, preambleLongs);
        if (version > 2) {
            throw new SketchesArgumentException("Unsupported serial version. Expected: 2 or lower, actual: " + version);
        }
        SerializerDeserializer.validateType(mem.getByte((long)offset++), SerializerDeserializer.SketchType.QuickSelectSketch);
        byte flags = mem.getByte((long)offset++);
        boolean bl = isBigEndian = (flags & 1 << Flags.IS_BIG_ENDIAN.ordinal()) > 0;
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Endian byte order mismatch");
        }
        this.nomEntries_ = 1 << mem.getByte((long)offset++);
        this.lgCurrentCapacity_ = mem.getByte((long)offset++);
        this.lgResizeFactor_ = mem.getByte((long)offset++);
        boolean isInSamplingMode = (flags & 1 << Flags.IS_IN_SAMPLING_MODE.ordinal()) > 0;
        float f = this.samplingProbability_ = isInSamplingMode ? mem.getFloat((long)offset) : 1.0f;
        if (isInSamplingMode) {
            offset += 4;
        }
        boolean bl2 = isThetaIncluded = (flags & 1 << Flags.IS_THETA_INCLUDED.ordinal()) > 0;
        if (isThetaIncluded) {
            this.theta_ = mem.getLong((long)offset);
            offset += 8;
        } else {
            this.theta_ = (long)(9.223372036854776E18 * (double)this.samplingProbability_);
        }
        int count = 0;
        boolean bl3 = hasEntries = (flags & 1 << Flags.HAS_ENTRIES.ordinal()) > 0;
        if (hasEntries) {
            count = mem.getInt((long)offset);
            offset += 4;
        }
        int currentCapacity = 1 << this.lgCurrentCapacity_;
        this.keys_ = new long[currentCapacity];
        for (int i = 0; i < count; ++i) {
            long key = mem.getLong((long)offset);
            Memory memRegion = mem.region((long)(offset += 8), mem.getCapacity() - (long)offset);
            DeserializeResult<S> summaryResult = deserializer.heapifySummary(memRegion);
            Summary summary = (Summary)summaryResult.getObject();
            offset += summaryResult.getSize();
            this.insert(key, summary);
        }
        this.isEmpty_ = (flags & 1 << Flags.IS_EMPTY.ordinal()) > 0;
        this.setRebuildThreshold();
    }

    @Override
    public int getRetainedEntries() {
        return this.count_;
    }

    public int getNominalEntries() {
        return this.nomEntries_;
    }

    public int getLgK() {
        return org.apache.datasketches.Util.simpleIntLog2(this.nomEntries_);
    }

    public float getSamplingProbability() {
        return this.samplingProbability_;
    }

    public int getCurrentCapacity() {
        return 1 << this.lgCurrentCapacity_;
    }

    public ResizeFactor getResizeFactor() {
        return ResizeFactor.getRF(this.lgResizeFactor_);
    }

    public void trim() {
        if (this.count_ > this.nomEntries_) {
            this.updateTheta();
            this.rebuild(this.keys_.length);
        }
    }

    public void reset() {
        this.isEmpty_ = true;
        this.count_ = 0;
        this.theta_ = (long)(9.223372036854776E18 * (double)this.samplingProbability_);
        int startingCapacity = Util.getStartingCapacity(this.nomEntries_, this.lgResizeFactor_);
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingCapacity);
        this.keys_ = new long[startingCapacity];
        this.summaries_ = null;
        this.setRebuildThreshold();
    }

    public CompactSketch<S> compact() {
        if (this.getRetainedEntries() == 0) {
            return new CompactSketch(null, null, this.theta_, this.isEmpty_);
        }
        long[] keys = new long[this.getRetainedEntries()];
        Summary[] summaries = (Summary[])Array.newInstance(this.summaries_.getClass().getComponentType(), this.getRetainedEntries());
        int i = 0;
        for (int j = 0; j < this.keys_.length; ++j) {
            if (this.summaries_[j] == null) continue;
            keys[i] = this.keys_[j];
            summaries[i] = this.summaries_[j].copy();
            ++i;
        }
        return new CompactSketch(keys, summaries, this.theta_, this.isEmpty_);
    }

    @Override
    public byte[] toByteArray() {
        boolean isThetaIncluded;
        Object summariesBytes = null;
        int summariesBytesLength = 0;
        if (this.count_ > 0) {
            summariesBytes = new byte[this.count_][];
            int i = 0;
            for (int j = 0; j < this.summaries_.length; ++j) {
                if (this.summaries_[j] == null) continue;
                summariesBytes[i] = this.summaries_[j].toByteArray();
                summariesBytesLength += summariesBytes[i].length;
                ++i;
            }
        }
        int sizeBytes = 8;
        if (this.isInSamplingMode()) {
            sizeBytes += 4;
        }
        boolean bl = this.isInSamplingMode() ? (float)this.theta_ < this.samplingProbability_ : (isThetaIncluded = this.theta_ < Long.MAX_VALUE);
        if (isThetaIncluded) {
            sizeBytes += 8;
        }
        if (this.count_ > 0) {
            sizeBytes += 4;
        }
        byte[] bytes = new byte[sizeBytes += 8 * this.count_ + summariesBytesLength];
        int offset = 0;
        bytes[offset++] = 1;
        bytes[offset++] = 2;
        bytes[offset++] = (byte)Family.TUPLE.getID();
        bytes[offset++] = (byte)SerializerDeserializer.SketchType.QuickSelectSketch.ordinal();
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        bytes[offset++] = (byte)((isBigEndian ? 1 << Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isInSamplingMode() ? 1 << Flags.IS_IN_SAMPLING_MODE.ordinal() : 0) | (this.isEmpty_ ? 1 << Flags.IS_EMPTY.ordinal() : 0) | (this.count_ > 0 ? 1 << Flags.HAS_ENTRIES.ordinal() : 0) | (isThetaIncluded ? 1 << Flags.IS_THETA_INCLUDED.ordinal() : 0));
        bytes[offset++] = (byte)Integer.numberOfTrailingZeros(this.nomEntries_);
        bytes[offset++] = (byte)this.lgCurrentCapacity_;
        bytes[offset++] = (byte)this.lgResizeFactor_;
        if (this.samplingProbability_ < 1.0f) {
            ByteArrayUtil.putFloatLE(bytes, offset, this.samplingProbability_);
            offset += 4;
        }
        if (isThetaIncluded) {
            ByteArrayUtil.putLongLE(bytes, offset, this.theta_);
            offset += 8;
        }
        if (this.count_ > 0) {
            ByteArrayUtil.putIntLE(bytes, offset, this.count_);
            offset += 4;
        }
        if (this.count_ > 0) {
            int i = 0;
            for (int j = 0; j < this.keys_.length; ++j) {
                if (this.summaries_[j] == null) continue;
                ByteArrayUtil.putLongLE(bytes, offset, this.keys_[j]);
                System.arraycopy(summariesBytes[i], 0, bytes, offset += 8, summariesBytes[i].length);
                offset += summariesBytes[i].length;
                ++i;
            }
        }
        return bytes;
    }

    void merge(long key, S summary, SummarySetOperations<S> summarySetOps) {
        this.isEmpty_ = false;
        if (key < this.theta_) {
            int index = this.findOrInsert(key);
            if (index < 0) {
                this.insertSummary(~index, summary.copy());
            } else {
                this.insertSummary(index, summarySetOps.union(this.summaries_[index], (Summary)summary));
            }
            this.rebuildIfNeeded();
        }
    }

    boolean isInSamplingMode() {
        return this.samplingProbability_ < 1.0f;
    }

    void setThetaLong(long theta) {
        this.theta_ = theta;
    }

    void setNotEmpty() {
        this.isEmpty_ = false;
    }

    SummaryFactory<S> getSummaryFactory() {
        return this.summaryFactory_;
    }

    int findOrInsert(long key) {
        int index = HashOperations.hashSearchOrInsert(this.keys_, this.lgCurrentCapacity_, key);
        if (index < 0) {
            ++this.count_;
        }
        return index;
    }

    S find(long key) {
        int index = HashOperations.hashSearch(this.keys_, this.lgCurrentCapacity_, key);
        if (index == -1) {
            return null;
        }
        return (S)this.summaries_[index];
    }

    boolean rebuildIfNeeded() {
        if (this.count_ < this.rebuildThreshold_) {
            return false;
        }
        if (this.keys_.length > this.nomEntries_) {
            this.updateTheta();
            this.rebuild();
        } else {
            this.rebuild(this.keys_.length * (1 << this.lgResizeFactor_));
        }
        return true;
    }

    void rebuild() {
        this.rebuild(this.keys_.length);
    }

    void insert(long key, S summary) {
        int index = HashOperations.hashInsertOnly(this.keys_, this.lgCurrentCapacity_, key);
        this.insertSummary(index, summary);
        ++this.count_;
    }

    private void updateTheta() {
        long[] keys = new long[this.count_];
        int i = 0;
        for (int j = 0; j < this.keys_.length; ++j) {
            if (this.summaries_[j] == null) continue;
            keys[i++] = this.keys_[j];
        }
        this.theta_ = QuickSelect.select(keys, 0, this.count_ - 1, this.nomEntries_);
    }

    private void rebuild(int newSize) {
        long[] oldKeys = this.keys_;
        Summary[] oldSummaries = this.summaries_;
        this.keys_ = new long[newSize];
        this.summaries_ = (Summary[])Array.newInstance(oldSummaries.getClass().getComponentType(), newSize);
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(newSize);
        this.count_ = 0;
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldSummaries[i] == null || oldKeys[i] >= this.theta_) continue;
            this.insert(oldKeys[i], oldSummaries[i]);
        }
        this.setRebuildThreshold();
    }

    private void setRebuildThreshold() {
        this.rebuildThreshold_ = this.keys_.length > this.nomEntries_ ? (int)((double)this.keys_.length * 0.9375) : (int)((double)this.keys_.length * 0.5);
    }

    protected void insertSummary(int index, S summary) {
        if (this.summaries_ == null) {
            this.summaries_ = (Summary[])Array.newInstance(summary.getClass(), this.keys_.length);
        }
        this.summaries_[index] = summary;
    }

    private static enum Flags {
        IS_BIG_ENDIAN,
        IS_IN_SAMPLING_MODE,
        IS_EMPTY,
        HAS_ENTRIES,
        IS_THETA_INCLUDED;

    }
}

