/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.BinomialBoundsN;
import org.apache.datasketches.Util;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.UpdatableSketch;

public abstract class Sketch<S extends Summary> {
    protected static final byte PREAMBLE_LONGS = 1;
    long[] keys_;
    S[] summaries_;
    long theta_;
    boolean isEmpty_ = true;

    Sketch() {
    }

    public double getEstimate() {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return (double)this.getRetainedEntries() / this.getTheta();
    }

    public double getUpperBound(int numStdDev) {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return BinomialBoundsN.getUpperBound(this.getRetainedEntries(), this.getTheta(), numStdDev, this.isEmpty_);
    }

    public double getLowerBound(int numStdDev) {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return BinomialBoundsN.getLowerBound(this.getRetainedEntries(), this.getTheta(), numStdDev, this.isEmpty_);
    }

    public boolean isEmpty() {
        return this.isEmpty_;
    }

    public boolean isEstimationMode() {
        return this.theta_ < Long.MAX_VALUE && !this.isEmpty();
    }

    public abstract int getRetainedEntries();

    public double getTheta() {
        return (double)this.theta_ / 9.223372036854776E18;
    }

    public abstract byte[] toByteArray();

    public SketchIterator<S> iterator() {
        return new SketchIterator(this.keys_, this.summaries_);
    }

    long getThetaLong() {
        return this.theta_;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("### ").append(this.getClass().getSimpleName()).append(" SUMMARY: ").append(Util.LS);
        sb.append("   Estimate                : ").append(this.getEstimate()).append(Util.LS);
        sb.append("   Upper Bound, 95% conf   : ").append(this.getUpperBound(2)).append(Util.LS);
        sb.append("   Lower Bound, 95% conf   : ").append(this.getLowerBound(2)).append(Util.LS);
        sb.append("   Theta (double)          : ").append(this.getTheta()).append(Util.LS);
        sb.append("   Theta (long)            : ").append(this.getThetaLong()).append(Util.LS);
        sb.append("   EstMode?                : ").append(this.isEstimationMode()).append(Util.LS);
        sb.append("   Empty?                  : ").append(this.isEmpty()).append(Util.LS);
        sb.append("   Retained Entries        : ").append(this.getRetainedEntries()).append(Util.LS);
        if (this instanceof UpdatableSketch) {
            UpdatableSketch updatable = (UpdatableSketch)this;
            sb.append("   Nominal Entries (k)     : ").append(updatable.getNominalEntries()).append(Util.LS);
            sb.append("   Current Capacity        : ").append(updatable.getCurrentCapacity()).append(Util.LS);
            sb.append("   Resize Factor           : ").append(updatable.getResizeFactor().getValue()).append(Util.LS);
            sb.append("   Sampling Probability (p): ").append(updatable.getSamplingProbability()).append(Util.LS);
        }
        sb.append("### END SKETCH SUMMARY").append(Util.LS);
        return sb.toString();
    }
}

