/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.HeapCompactSketch;
import org.apache.datasketches.theta.PreambleUtil;

final class HeapCompactUnorderedSketch
extends HeapCompactSketch {
    HeapCompactUnorderedSketch(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong) {
        super(cache, empty, seedHash, curCount, thetaLong);
    }

    static CompactSketch heapifyInstance(Memory srcMem, long seed) {
        short memSeedHash = (short)PreambleUtil.extractSeedHash(srcMem);
        short computedSeedHash = Util.computeSeedHash(seed);
        Util.checkSeedHashes(memSeedHash, computedSeedHash);
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        boolean empty = PreambleUtil.isEmpty(srcMem);
        int curCount = 0;
        long thetaLong = Long.MAX_VALUE;
        long[] cache = new long[]{};
        curCount = PreambleUtil.extractCurCount(srcMem);
        cache = new long[curCount];
        if (preLongs == 2) {
            srcMem.getLongArray(16L, cache, 0, curCount);
        } else {
            srcMem.getLongArray(24L, cache, 0, curCount);
            thetaLong = PreambleUtil.extractThetaLong(srcMem);
        }
        return new HeapCompactUnorderedSketch(cache, empty, memSeedHash, curCount, thetaLong);
    }

    static CompactSketch compact(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong) {
        return new HeapCompactUnorderedSketch(cache, empty, seedHash, curCount, thetaLong);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(false);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

