/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import java.util.Arrays;
import org.apache.datasketches.hive.theta.ObjectInspectorValidator;
import org.apache.datasketches.hive.theta.UnionEvaluator;
import org.apache.datasketches.hive.theta.UnionState;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="dataToSketch", value="_FUNC_(expr, size, prob, seed) - Compute a sketch of given size, sampling probability and seed on data 'expr'", extended="Example:\n> SELECT dataToSketch(val, 16384) FROM src;\nThe return value is a binary blob that can be operated on by other sketch related functions. The sketch size is optional, must be a power of 2 and controls the relative error expected from the sketch. A size of 16384 can be expected to yield errors of roughly +-1.5% in the estimation of uniques. The default size is defined in the sketches-core library and at the time of this writing was 4096 (about 3% error). The sampling probability is optional and must be from 0 to 1. The default is 1 (no sampling) The seed is optional, and using it is not recommended unless you really know why you need it")
public class DataToSketchUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] parameters = info.getParameterObjectInspectors();
        if (parameters.length < 1) {
            throw new UDFArgumentException("Please specify at least 1 argument");
        }
        if (parameters.length > 4) {
            throw new UDFArgumentException("Please specify no more than 4 arguments");
        }
        ObjectInspectorValidator.validateCategoryPrimitive(parameters[0], 0);
        if (parameters.length > 1) {
            ObjectInspectorValidator.validateIntegralParameter(parameters[1], 1);
            if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)parameters[1])) {
                throw new UDFArgumentTypeException(1, "The second argument must be a constant");
            }
        }
        if (parameters.length > 2) {
            ObjectInspectorValidator.validateFloatingPointParameter(parameters[2], 2);
            if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)parameters[2])) {
                throw new UDFArgumentTypeException(2, "The third argument must be a constant");
            }
        }
        if (parameters.length > 3) {
            ObjectInspectorValidator.validateIntegralParameter(parameters[3], 3);
            if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)parameters[3])) {
                throw new UDFArgumentTypeException(3, "The fourth argument must be a constant");
            }
        }
        return new DataToSketchEvaluator();
    }

    public static class DataToSketchEvaluator
    extends UnionEvaluator {
        private transient PrimitiveObjectInspector samplingProbabilityObjectInspector;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
            super.init(mode, parameters);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputObjectInspector = (PrimitiveObjectInspector)parameters[0];
                if (parameters.length > 1) {
                    this.nominalEntriesObjectInspector = (PrimitiveObjectInspector)parameters[1];
                }
                if (parameters.length > 2) {
                    this.samplingProbabilityObjectInspector = (PrimitiveObjectInspector)parameters[2];
                }
                if (parameters.length > 3) {
                    this.seedObjectInspector = (PrimitiveObjectInspector)parameters[3];
                }
            } else {
                this.intermediateObjectInspector = (StructObjectInspector)parameters[0];
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "seed", "sketch"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY)));
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            if (parameters[0] == null) {
                return;
            }
            UnionState state = (UnionState)agg;
            if (!state.isInitialized()) {
                this.initializeState(state, parameters);
            }
            state.update(parameters[0], this.inputObjectInspector);
        }

        private void initializeState(UnionState state, Object[] parameters) {
            int sketchSize = 4096;
            if (this.nominalEntriesObjectInspector != null) {
                sketchSize = PrimitiveObjectInspectorUtils.getInt((Object)parameters[1], (PrimitiveObjectInspector)this.nominalEntriesObjectInspector);
            }
            float samplingProbability = 1.0f;
            if (this.samplingProbabilityObjectInspector != null) {
                samplingProbability = PrimitiveObjectInspectorUtils.getFloat((Object)parameters[2], (PrimitiveObjectInspector)this.samplingProbabilityObjectInspector);
            }
            long seed = 9001L;
            if (this.seedObjectInspector != null) {
                seed = PrimitiveObjectInspectorUtils.getLong((Object)parameters[3], (PrimitiveObjectInspector)this.seedObjectInspector);
            }
            state.init(sketchSize, samplingProbability, seed);
        }
    }
}

