/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.frequencies;

import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.hive.frequencies.ItemsEvaluator;
import org.apache.datasketches.hive.frequencies.ItemsState;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

public abstract class DataToItemsSketchUDAF<T>
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] inspectors = info.getParameterObjectInspectors();
        if (inspectors.length != 2) {
            throw new UDFArgumentException("Two arguments expected");
        }
        if (inspectors[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Primitive argument expected, but " + inspectors[0].getTypeName() + " was recieved");
        }
        if (inspectors[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Primitive argument expected, but " + inspectors[1].getTypeName() + " was recieved");
        }
        PrimitiveObjectInspector inspector2 = (PrimitiveObjectInspector)inspectors[1];
        if (inspector2.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw new UDFArgumentTypeException(0, "Integer value expected as the second argument, but " + inspector2.getPrimitiveCategory().name() + " was received");
        }
        return this.createEvaluator();
    }

    public abstract GenericUDAFEvaluator createEvaluator();

    public static abstract class DataToItemsSketchEvaluator<T>
    extends ItemsEvaluator<T> {
        private PrimitiveObjectInspector maxMapSizeObjectInspector;

        public DataToItemsSketchEvaluator(ArrayOfItemsSerDe<T> serDe) {
            super(serDe);
        }

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
            ObjectInspector result = super.init(mode, parameters);
            if ((mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) && parameters.length > 1) {
                this.maxMapSizeObjectInspector = (PrimitiveObjectInspector)parameters[1];
            }
            return result;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer buf, Object[] data) throws HiveException {
            if (data[0] == null) {
                return;
            }
            ItemsState state = (ItemsState)buf;
            if (!state.isInitialized()) {
                int maxMapSize = PrimitiveObjectInspectorUtils.getInt((Object)data[1], (PrimitiveObjectInspector)this.maxMapSizeObjectInspector);
                state.init(maxMapSize);
            }
            state.update(this.extractValue(data[0], (ObjectInspector)this.inputObjectInspector));
        }

        public abstract T extractValue(Object var1, ObjectInspector var2) throws HiveException;
    }
}

