/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyHelper {
    public static final Logger LOG = LoggerFactory.getLogger(PropertyHelper.class);

    private PropertyHelper() {
    }

    public static Collection<String> getMultiValueProperty(Object property) {
        if (property == null) {
            return Collections.emptyList();
        }
        if (property instanceof Collection) {
            return (Collection)property;
        }
        if (property instanceof String[]) {
            return Arrays.asList((String[])property);
        }
        return Collections.singleton(property.toString());
    }

    public static String getProperty(Map<String, Object> dict, String name) {
        Object value = dict.get(name);
        return value instanceof String ? (String)value : null;
    }

    public static String getFirstNonEmptyStringProperty(Map<String, Object> dict, String ... keys) {
        for (String key : keys) {
            String value = PropertyHelper.getProperty(dict, key);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

