/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.common.proxy;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceException;

public class ExceptionMapper {
    private static final String REMOTE_EXCEPTION_TYPE = "REMOTE";
    private Map<Method, Set<Class<?>>> exceptionsMap = new HashMap();

    public ExceptionMapper(Class<?> iType) {
        this.introspectTypeForExceptions(iType);
    }

    public Throwable mapException(Method m, Throwable ex) throws Throwable {
        Throwable cause = ex.getCause() == null ? ex : ex.getCause();
        Set<Class<?>> excTypes = this.exceptionsMap.get(m);
        if (excTypes != null) {
            for (Class<?> type : excTypes) {
                if (type.isAssignableFrom(ex.getClass())) {
                    return ex;
                }
                if (!type.isAssignableFrom(cause.getClass())) continue;
                return cause;
            }
        }
        return new ServiceException(REMOTE_EXCEPTION_TYPE, ex);
    }

    private void introspectTypeForExceptions(Class<?> iType) {
        for (Method m : iType.getDeclaredMethods()) {
            this.addExceptions(m);
        }
        for (Method m : iType.getMethods()) {
            this.addExceptions(m);
        }
    }

    private void addExceptions(Method m) {
        for (Class<?> excType : m.getExceptionTypes()) {
            if (!Exception.class.isAssignableFrom(excType)) continue;
            this.getCurrentExTypes(m).add(excType);
        }
    }

    private Set<Class<?>> getCurrentExTypes(Method m) {
        Set<Class<?>> types = this.exceptionsMap.get(m);
        if (types == null) {
            types = new HashSet();
            this.exceptionsMap.put(m, types);
        }
        return types;
    }
}

