/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.common.intent.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.cxf.dosgi.common.api.IntentsProvider;
import org.apache.cxf.dosgi.common.intent.IntentManager;
import org.apache.cxf.dosgi.common.util.PropertyHelper;
import org.apache.cxf.feature.Features;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={IntentManager.class})
public class IntentManagerImpl
implements IntentManager {
    static final Logger LOG = LoggerFactory.getLogger(IntentManagerImpl.class);
    private static final int DEFAULT_INTENT_TIMEOUT = 30000;
    private final Map<String, Object> intentMap = new HashMap<String, Object>();
    private final long maxIntentWaitTime = 30000L;
    private ServiceTracker<Object, Object> tracker;

    @Activate
    public void activate(BundleContext context) throws InvalidSyntaxException {
        String filterSt = String.format("(|(%s=*)(%s=*))", "org.apache.cxf.dosgi.IntentName", "intentName");
        Filter filter = FrameworkUtil.createFilter((String)filterSt);
        this.tracker = new ServiceTracker<Object, Object>(context, filter, null){

            public Object addingService(ServiceReference<Object> reference) {
                Object intent = super.addingService(reference);
                IntentManagerImpl.this.addIntent(intent, this.getName(reference));
                return intent;
            }

            public void removedService(ServiceReference<Object> reference, Object intent) {
                IntentManagerImpl.this.removeIntent(intent, this.getName(reference));
                super.removedService(reference, intent);
            }

            private String getName(ServiceReference<Object> reference) {
                String name = (String)reference.getProperty("org.apache.cxf.dosgi.IntentName");
                String name2 = (String)reference.getProperty("intentName");
                return name != null ? name : name2;
            }
        };
        this.tracker.open();
    }

    @Deactivate
    public void deactivate() {
        this.tracker.close();
    }

    public synchronized void addIntent(Object intent, String intentName) {
        LOG.info("Adding custom intent " + intentName);
        this.intentMap.put(intentName, intent);
    }

    public synchronized void removeIntent(Object intent, String intentName) {
        this.intentMap.remove(intentName);
    }

    @Override
    public synchronized List<Object> getRequiredIntents(Set<String> requiredIntents) {
        String[] intentNames = this.assertAllIntentsSupported(requiredIntents);
        ArrayList<Object> intents = new ArrayList<Object>();
        for (String intentName : intentNames) {
            Object intent = this.intentMap.get(intentName);
            if (intent instanceof Callable) {
                try {
                    List curIntents = (List)((Callable)intent).call();
                    intents.addAll(curIntents);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (intent instanceof IntentsProvider) {
                try {
                    IntentsProvider provider = (IntentsProvider)intent;
                    List<?> curIntents = provider.getIntents();
                    intents.addAll(curIntents);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            intents.add(intent);
        }
        return intents;
    }

    @Override
    public <T> T getIntent(Class<? extends T> type, List<Object> intents) {
        List<T> selectedIntents = this.getIntents(type, intents);
        if (selectedIntents.isEmpty()) {
            return null;
        }
        if (selectedIntents.size() > 1) {
            LOG.warn("More than one intent of type " + type + " present. Using only the first one.");
        }
        return selectedIntents.iterator().next();
    }

    @Override
    public <T> List<T> getIntents(Class<? extends T> type, List<Object> intents) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object intent : intents) {
            if (!type.isInstance(intent)) continue;
            result.add(type.cast(intent));
        }
        return result;
    }

    public synchronized String[] assertAllIntentsSupported(Set<String> requiredIntents) {
        Set<String> unsupportedIntents;
        long endTime = System.currentTimeMillis() + 30000L;
        boolean first = true;
        do {
            unsupportedIntents = this.getMissingIntents(requiredIntents);
            long remainingSeconds = (endTime - System.currentTimeMillis()) / 1000L;
            if (unsupportedIntents.isEmpty() || remainingSeconds <= 0L) continue;
            String msg = "Waiting for custom intents {} timeout in {} seconds";
            if (first) {
                LOG.info(msg, (Object)Arrays.toString(unsupportedIntents.toArray()), (Object)remainingSeconds);
                first = false;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(msg, (Object)Arrays.toString(unsupportedIntents.toArray()), (Object)remainingSeconds);
            }
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        } while (!unsupportedIntents.isEmpty() && System.currentTimeMillis() < endTime);
        if (!unsupportedIntents.isEmpty()) {
            throw new RuntimeException("service cannot be exported because the following intents are not supported by this RSA: " + unsupportedIntents);
        }
        return requiredIntents.toArray(new String[0]);
    }

    private synchronized Set<String> getMissingIntents(Collection<String> requiredIntents) {
        HashSet<String> unsupportedIntents = new HashSet<String>();
        unsupportedIntents.clear();
        for (String ri : requiredIntents) {
            if (this.intentMap.containsKey(ri)) continue;
            unsupportedIntents.add(ri);
        }
        return unsupportedIntents;
    }

    @Override
    public Set<String> getExported(Map<String, Object> sd) {
        HashSet<String> allIntents = new HashSet<String>();
        Collection<String> intents = PropertyHelper.getMultiValueProperty(sd.get("service.exported.intents"));
        allIntents.addAll(IntentManagerImpl.parseIntents(intents));
        Collection<String> intents2 = PropertyHelper.getMultiValueProperty(sd.get("service.exported.intents.extra"));
        allIntents.addAll(IntentManagerImpl.parseIntents(intents2));
        return allIntents;
    }

    @Override
    public List<Object> getIntentsFromService(Object serviceBean) {
        Features features;
        ArrayList<Object> intents = new ArrayList<Object>();
        if (serviceBean instanceof IntentsProvider) {
            intents.addAll(((IntentsProvider)serviceBean).getIntents());
        }
        if ((features = serviceBean.getClass().getAnnotation(Features.class)) != null && features.classes() != null) {
            for (Class clazz : features.classes()) {
                try {
                    intents.add(clazz.newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate feature from class " + clazz.getName(), e);
                }
            }
        }
        return intents;
    }

    @Override
    public Set<String> getImported(Map<String, Object> sd) {
        Collection<String> intents = PropertyHelper.getMultiValueProperty(sd.get("service.intents"));
        return new HashSet<String>(intents);
    }

    private static Collection<String> parseIntents(Collection<String> intents) {
        ArrayList<String> parsed = new ArrayList<String>();
        for (String intent : intents) {
            parsed.addAll(Arrays.asList(intent.split("[ ]")));
        }
        return parsed;
    }
}

