/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wadlto;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.maven_plugin.common.DocumentArtifact;
import org.apache.cxf.maven_plugin.wadlto.Option;
import org.apache.cxf.maven_plugin.wadlto.WadlOption;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public final class OptionLoader {
    private static final String WADL_TYPE = "wadl";
    private static final String WADL_OPTIONS = "-options$";
    private static final String WADL_BINDINGS = "-binding-?\\d*.xml$";

    private OptionLoader() {
    }

    public static List<WadlOption> loadWsdlOptionsFromDependencies(MavenProject project, Option defaultOptions, File outputDir) {
        ArrayList<WadlOption> options = new ArrayList<WadlOption>();
        Set dependencies = project.getDependencyArtifacts();
        for (Artifact artifact : dependencies) {
            WadlOption option = OptionLoader.generateWsdlOptionFromArtifact(artifact, outputDir);
            if (option == null) continue;
            if (defaultOptions != null) {
                option.merge(defaultOptions);
            }
            options.add(option);
        }
        return options;
    }

    private static WadlOption generateWsdlOptionFromArtifact(Artifact artifact, File outputDir) {
        if (!WADL_TYPE.equals(artifact.getType())) {
            return null;
        }
        WadlOption option = new WadlOption();
        DocumentArtifact wsdlArtifact = new DocumentArtifact();
        wsdlArtifact.setArtifactId(artifact.getArtifactId());
        wsdlArtifact.setGroupId(artifact.getGroupId());
        wsdlArtifact.setType(artifact.getType());
        wsdlArtifact.setVersion(artifact.getVersion());
        option.setWadlArtifact(wsdlArtifact);
        option.setOutputDir(outputDir);
        return option;
    }

    public static List<WadlOption> loadWadlOptionsFromFile(File wadlBasedir, String[] includes, String[] excludes, Option defaultOptions, File defaultOutputDir) throws MojoExecutionException {
        if (wadlBasedir == null) {
            return new ArrayList<WadlOption>();
        }
        if (!wadlBasedir.exists()) {
            throw new MojoExecutionException(wadlBasedir + " does not exist");
        }
        List<File> wadlFiles = OptionLoader.getWadlFiles(wadlBasedir, includes, excludes);
        ArrayList<WadlOption> wadlOptions = new ArrayList<WadlOption>();
        for (File wadl : wadlFiles) {
            WadlOption wadlOption = OptionLoader.generateWadlOptionFromFile(wadl, defaultOptions, defaultOutputDir);
            if (wadlOption == null) continue;
            wadlOptions.add(wadlOption);
        }
        return wadlOptions;
    }

    private static String joinWithComma(String[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        return String.join((CharSequence)",", arr);
    }

    private static List<File> getWadlFiles(File dir, String[] includes, String[] excludes) throws MojoExecutionException {
        ArrayList exList = new ArrayList();
        if (excludes != null) {
            Collections.addAll(exList, excludes);
        }
        Collections.addAll(exList, FileUtils.getDefaultExcludes());
        String inc = OptionLoader.joinWithComma(includes);
        String ex = OptionLoader.joinWithComma(exList.toArray(new String[0]));
        try {
            List newfiles = FileUtils.getFiles((File)dir, (String)inc, (String)ex);
            return CastUtils.cast((List)newfiles);
        }
        catch (IOException exc) {
            throw new MojoExecutionException(exc.getMessage(), (Exception)exc);
        }
    }

    protected static WadlOption generateWadlOptionFromFile(File wadl, Option defaultOptions, File defaultOutputDir) throws MojoExecutionException {
        List bindingFiles;
        if (wadl == null || !wadl.exists()) {
            return null;
        }
        String wadlFileName = wadl.getName();
        int idx = wadlFileName.toLowerCase().lastIndexOf(".wadl");
        if (idx == -1) {
            idx = wadlFileName.lastIndexOf(46);
        }
        if (idx == -1) {
            return null;
        }
        WadlOption wadlOption = new WadlOption();
        if (defaultOptions != null) {
            wadlOption.merge(defaultOptions);
        }
        String wadlName = wadlFileName.substring(0, idx);
        String[] options = OptionLoader.readOptionsFromFile(wadl.getParentFile(), wadlName);
        if (options.length > 0) {
            Collections.addAll(wadlOption.getExtraargs(), options);
        }
        if ((bindingFiles = org.apache.cxf.helpers.FileUtils.getFiles((File)wadl.getParentFile(), (String)(wadlName + WADL_BINDINGS))) != null) {
            for (File binding : bindingFiles) {
                wadlOption.addBindingFile(binding);
            }
        }
        wadlOption.setWadl(wadl.toURI().toString());
        if (wadlOption.getOutputDir() == null) {
            wadlOption.setOutputDir(defaultOutputDir);
        }
        return wadlOption;
    }

    private static String[] readOptionsFromFile(File dir, String wsdlName) throws MojoExecutionException {
        String[] noOptions = new String[]{};
        List files = org.apache.cxf.helpers.FileUtils.getFiles((File)dir, (String)(wsdlName + WADL_OPTIONS));
        if (files.isEmpty()) {
            return noOptions;
        }
        File optionsFile = (File)files.iterator().next();
        if (optionsFile == null || !optionsFile.exists()) {
            return noOptions;
        }
        try {
            List lines = org.apache.cxf.helpers.FileUtils.readLines((File)optionsFile);
            if (lines.isEmpty()) {
                return noOptions;
            }
            return ((String)lines.iterator().next()).split(" ");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading options from file " + optionsFile.getAbsolutePath(), e);
        }
    }
}

