/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wadlto;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.CollectionUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.maven_plugin.common.DocumentArtifact;
import org.apache.cxf.maven_plugin.common.ForkOnceCodeGenerator;
import org.apache.cxf.maven_plugin.wadlto.Option;
import org.apache.cxf.maven_plugin.wadlto.WadlOption;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wadlto.WADLToJava;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractCodeGeneratorMojo
extends AbstractMojo {
    @Parameter(property="cxf.testSourceRoot")
    File testSourceRoot;
    @Parameter(required=true, property="cxf.sourceRoot", defaultValue="${project.build.directory}/generated-sources/cxf")
    File sourceRoot;
    @Parameter(required=true, property="project.build.outputDirectory")
    String classesDirectory;
    @Parameter(required=true, property="project")
    MavenProject project;
    @Parameter
    Option defaultOptions = new Option();
    @Parameter(property="cxf.markerDirectory", defaultValue="${project.build.directory}/cxf-codegen-plugin-markers")
    File markerDirectory;
    @Parameter(property="cxf.useCompileClasspath", defaultValue="false")
    boolean useCompileClasspath;
    @Parameter(property="cxf.disableDirectoryScan", defaultValue="false")
    boolean disableDirectoryScan;
    @Parameter(property="cxf.disableDependencyScan", defaultValue="false")
    boolean disableDependencyScan;
    @Parameter
    String[] includes;
    @Parameter
    String[] excludes;
    @Parameter(defaultValue="false")
    String fork;
    @Parameter
    String additionalJvmArgs;
    @Parameter(readonly=true, required=true, property="session")
    private MavenSession mavenSession;
    @Parameter(readonly=true, required=true, property="plugin.artifacts")
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${java.home}/bin/java")
    private String javaExecutable;
    @Component
    private RepositorySystem repositorySystem;
    private ClassLoader resourceClassLoader;

    private Artifact resolveRemoteWadlArtifact(Artifact artifact) throws MojoExecutionException {
        List rProjects = this.mavenSession.getProjects();
        for (MavenProject rProject : rProjects) {
            if (!artifact.getGroupId().equals(rProject.getGroupId()) || !artifact.getArtifactId().equals(rProject.getArtifactId()) || !artifact.getVersion().equals(rProject.getVersion())) continue;
            Set artifacts = rProject.getArtifacts();
            for (Artifact pArtifact : artifacts) {
                if (!"wadl".equals(pArtifact.getType())) continue;
                return pArtifact;
            }
        }
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveRoot(true).setResolveTransitively(false);
        request.setServers(this.mavenSession.getRequest().getServers());
        request.setMirrors(this.mavenSession.getRequest().getMirrors());
        request.setProxies(this.mavenSession.getRequest().getProxies());
        request.setLocalRepository(this.mavenSession.getLocalRepository());
        request.setRemoteRepositories(this.mavenSession.getRequest().getRemoteRepositories());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        Artifact resolvedArtifact = result.getOriginatingArtifact();
        if (resolvedArtifact == null && !CollectionUtils.isEmpty((Collection)result.getArtifacts())) {
            resolvedArtifact = (Artifact)result.getArtifacts().iterator().next();
        }
        return resolvedArtifact;
    }

    protected void downloadRemoteDocs(List<WadlOption> effectiveOptions) throws MojoExecutionException {
        for (WadlOption option : effectiveOptions) {
            DocumentArtifact wadlA = option.getWadlArtifact();
            if (wadlA == null) {
                return;
            }
            Artifact wadlArtifact = this.repositorySystem.createArtifact(wadlA.getGroupId(), wadlA.getArtifactId(), wadlA.getVersion(), wadlA.getType());
            if ((wadlArtifact = this.resolveRemoteWadlArtifact(wadlArtifact)) == null) continue;
            String path = wadlArtifact.getFile().getAbsolutePath();
            this.getLog().info((CharSequence)("Resolved WADL artifact to file " + path));
            option.setWadl(path);
        }
    }

    private void addPluginArtifact(Set<URI> artifactsPath) {
        URL url = ((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + ".class");
        try {
            File file;
            URI uri;
            String s;
            if ("jar".equals(url.getProtocol()) && (s = url.getPath()).contains("!")) {
                s = s.substring(0, s.indexOf(33));
                url = new URL(s);
            }
            if ((uri = new URI(url.getProtocol(), null, url.getPath(), null, null)).getSchemeSpecificPart().endsWith(".class")) {
                String s2 = uri.toString();
                s2 = s2.substring(0, s2.length() - 6 - ((Object)((Object)this)).getClass().getName().length());
                uri = new URI(s2);
            }
            if ((file = new File(uri)).exists()) {
                artifactsPath.add(file.toURI());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void forkOnce(Set<URI> classPath, List<WadlOption> effectiveOptions) throws MojoExecutionException {
        LinkedList<WadlOption> toDo = new LinkedList<WadlOption>();
        LinkedList<List<String>> wargs = new LinkedList<List<String>>();
        for (WadlOption wadlOption : effectiveOptions) {
            File outputDirFile = wadlOption.getOutputDir();
            outputDirFile.mkdirs();
            URI uRI = this.project.getBasedir().toURI();
            for (URI wadlURI : wadlOption.getWadlURIs(uRI, this.getResourceLoader())) {
                File doneFile = this.getDoneFile(uRI, wadlURI);
                if (!this.shouldRun(wadlOption, doneFile, wadlURI)) continue;
                doneFile.delete();
                toDo.add(wadlOption);
                wargs.add(wadlOption.generateCommandLine(outputDirFile, uRI, wadlURI, this.getLog().isDebugEnabled()));
            }
        }
        if (wargs.isEmpty()) {
            return;
        }
        LinkedHashSet<URI> artifactsPath = new LinkedHashSet<URI>();
        for (Artifact a : this.pluginArtifacts) {
            File file = a.getFile();
            if (file == null) {
                throw new MojoExecutionException("Unable to find file for artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion());
            }
            artifactsPath.add(file.toURI());
        }
        this.addPluginArtifact(artifactsPath);
        artifactsPath.addAll(classPath);
        String[] stringArray = this.createForkOnceArgs(wargs);
        this.runForked(artifactsPath, ForkOnceCodeGenerator.class, stringArray);
        for (WadlOption wadlOption : toDo) {
            File[] dirs = wadlOption.getDeleteDirs();
            if (dirs != null) {
                for (int idx = 0; idx < dirs.length; ++idx) {
                    this.deleteDir(dirs[idx]);
                }
            }
            URI basedir = this.project.getBasedir().toURI();
            for (URI wadlURI : wadlOption.getWadlURIs(basedir, this.getResourceLoader())) {
                File doneFile = this.getDoneFile(basedir, wadlURI);
                try {
                    doneFile.createNewFile();
                }
                catch (Throwable e) {
                    this.getLog().warn((CharSequence)("Could not create marker file " + doneFile.getAbsolutePath()));
                    this.getLog().debug(e);
                }
            }
        }
    }

    private String[] createForkOnceArgs(List<List<String>> wargs) throws MojoExecutionException {
        try {
            File f = FileUtils.createTempFile((String)"cxf-w2j", (String)"args");
            PrintWriter fw = new PrintWriter(new FileWriter(f));
            for (List<String> args : wargs) {
                fw.println(Integer.toString(args.size()));
                for (String s : args) {
                    fw.println(s);
                }
            }
            fw.println("-1");
            fw.close();
            return new String[]{f.getAbsolutePath()};
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not create argument file", (Exception)ex);
        }
    }

    private ClassLoader getResourceLoader() throws MojoExecutionException {
        if (this.resourceClassLoader == null) {
            try {
                Resource r;
                int i;
                List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
                List resources = this.project.getResources();
                List testResources = this.project.getTestResources();
                URL[] runtimeUrls = new URL[runtimeClasspathElements.size() + resources.size() + testResources.size()];
                for (i = 0; i < runtimeClasspathElements.size(); ++i) {
                    String element = (String)runtimeClasspathElements.get(i);
                    runtimeUrls[i] = new File(element).toURI().toURL();
                }
                i = 0;
                int j = runtimeClasspathElements.size();
                while (i < resources.size()) {
                    r = (Resource)resources.get(i);
                    runtimeUrls[j] = new File(r.getDirectory()).toURI().toURL();
                    ++i;
                    ++j;
                }
                i = 0;
                j = runtimeClasspathElements.size() + resources.size();
                while (i < testResources.size()) {
                    r = (Resource)testResources.get(i);
                    runtimeUrls[j] = new File(r.getDirectory()).toURI().toURL();
                    ++i;
                    ++j;
                }
                this.resourceClassLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        return this.resourceClassLoader;
    }

    protected Bus callCodeGenerator(WadlOption option, Bus bus, Set<URI> classPath) throws MojoExecutionException {
        File outputDirFile = option.getOutputDir();
        outputDirFile.mkdirs();
        URI basedir = this.project.getBasedir().toURI();
        for (URI wadlURI : option.getWadlURIs(basedir, this.getResourceLoader())) {
            File doneFile = this.getDoneFile(basedir, wadlURI);
            if (!this.shouldRun(option, doneFile, wadlURI)) {
                return bus;
            }
            doneFile.delete();
            List<String> list = option.generateCommandLine(outputDirFile, basedir, wadlURI, this.getLog().isDebugEnabled());
            Object[] args = list.toArray(new String[0]);
            this.getLog().debug((CharSequence)("Calling wadl2java with args: " + Arrays.toString(args)));
            if (!"false".equals(this.fork)) {
                LinkedHashSet<URI> artifactsPath = new LinkedHashSet<URI>();
                for (Artifact a : this.pluginArtifacts) {
                    File file = a.getFile();
                    if (file == null) {
                        throw new MojoExecutionException("Unable to find file for artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion());
                    }
                    artifactsPath.add(file.toURI());
                }
                this.addPluginArtifact(artifactsPath);
                artifactsPath.addAll(classPath);
                this.runForked(artifactsPath, WADLToJava.class, (String[])args);
            } else {
                if (bus == null) {
                    bus = BusFactory.newInstance().createBus();
                    BusFactory.setThreadDefaultBus((Bus)bus);
                }
                try {
                    new WADLToJava((String[])args).run(new ToolContext());
                }
                catch (Throwable e) {
                    this.getLog().debug(e);
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
            try {
                doneFile.createNewFile();
            }
            catch (Throwable e) {
                this.getLog().warn((CharSequence)("Could not create marker file " + doneFile.getAbsolutePath()));
                this.getLog().debug(e);
            }
        }
        return bus;
    }

    private File getJavaExecutable() throws IOException {
        String exe = SystemUtils.IS_OS_WINDOWS && !this.javaExecutable.endsWith(".exe") ? ".exe" : "";
        File javaExe = new File(this.javaExecutable + exe);
        if (!javaExe.isFile()) {
            throw new IOException("The java executable '" + javaExe + "' doesn't exist or is not a file. Verify the <javaExecutable/> parameter.");
        }
        return javaExe;
    }

    private void runForked(Set<URI> classPath, Class<?> cls, String[] args) throws MojoExecutionException {
        StringBuilder msg;
        int exitCode;
        this.getLog().info((CharSequence)"Running wadl2java in fork mode...");
        Commandline cmd = new Commandline();
        cmd.getShell().setQuotedArgumentsEnabled(true);
        cmd.setWorkingDirectory(this.project.getBuild().getDirectory());
        try {
            cmd.setExecutable(this.getJavaExecutable().getAbsolutePath());
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        cmd.createArg().setLine(this.additionalJvmArgs);
        File file = null;
        try {
            file = FileUtils.createTempFile((String)"cxf-codegen", (String)".jar");
            JarArchiver jar = new JarArchiver();
            jar.setDestFile(file.getAbsoluteFile());
            Manifest manifest = new Manifest();
            Manifest.Attribute attr = new Manifest.Attribute();
            attr.setName("Class-Path");
            StringBuilder b = new StringBuilder(8000);
            for (URI cp : classPath) {
                b.append(cp.toURL().toExternalForm()).append(' ');
            }
            attr.setValue(b.toString());
            manifest.getMainSection().addConfiguredAttribute(attr);
            attr = new Manifest.Attribute();
            attr.setName("Main-Class");
            attr.setValue(cls.getName());
            manifest.getMainSection().addConfiguredAttribute(attr);
            jar.addConfiguredManifest(manifest);
            jar.createArchive();
            cmd.createArg().setValue("-jar");
            cmd.createArg().setValue(file.getAbsolutePath());
        }
        catch (Exception e1) {
            throw new MojoExecutionException("Could not create runtime jar", e1);
        }
        cmd.addArguments(args);
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
        }
        catch (CommandLineException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        String output = StringUtils.isEmpty((String)out.getOutput()) ? null : '\n' + out.getOutput().trim();
        String cmdLine = CommandLineUtils.toString((String[])cmd.getCommandline());
        if (exitCode != 0) {
            if (StringUtils.isNotEmpty((String)output)) {
                this.getLog().info((CharSequence)output);
            }
            msg = new StringBuilder("\nExit code: ");
            msg.append(exitCode);
            if (StringUtils.isNotEmpty((String)err.getOutput())) {
                msg.append(" - ").append(err.getOutput());
            }
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
        if (file != null) {
            file.delete();
        }
        if (StringUtils.isNotEmpty((String)err.getOutput()) && err.getOutput().contains("WADL2Java Error")) {
            msg = new StringBuilder();
            msg.append(err.getOutput());
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
    }

    private File getDoneFile(URI basedir, URI wadlURI) {
        String doneFileName = wadlURI.toString();
        if (doneFileName.startsWith(basedir.toString())) {
            doneFileName = doneFileName.substring(basedir.toString().length());
        }
        doneFileName = doneFileName.replace('?', '_').replace('&', '_').replace('/', '_').replace('\\', '_').replace(':', '_');
        return new File(this.markerDirectory, "." + doneFileName + ".DONE");
    }

    private boolean shouldRun(WadlOption wadlOption, File doneFile, URI wadlURI) {
        long timestamp = 0L;
        if ("file".equals(wadlURI.getScheme())) {
            timestamp = new File(wadlURI).lastModified();
        } else {
            try {
                timestamp = wadlURI.toURL().openConnection().getDate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean doWork = false;
        if (!doneFile.exists()) {
            doWork = true;
        } else if (timestamp > doneFile.lastModified()) {
            doWork = true;
        } else {
            File[] files = wadlOption.getDependencies();
            if (files != null) {
                for (int z = 0; z < files.length; ++z) {
                    if (files[z].lastModified() <= doneFile.lastModified()) continue;
                    doWork = true;
                }
            }
        }
        return doWork;
    }

    protected boolean deleteDir(File f) {
        File[] files;
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (int idx = 0; idx < files.length; ++idx) {
                this.deleteDir(files[idx]);
            }
        }
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }
}

