/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.testutil.common.TestUtil;

public abstract class AbstractTestServerBase {
    boolean inProcess;

    protected abstract void run() throws Exception;

    protected Logger getLog() {
        return LogUtils.getLogger(this.getClass());
    }

    public void startInProcess() throws Exception {
        this.inProcess = true;
        this.run();
        this.ready();
    }

    public boolean stopInProcess() throws Exception {
        boolean ret = true;
        this.tearDown();
        if (this.verify(this.getLog())) {
            if (!this.inProcess) {
                System.out.println("server passed");
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public void start() throws Exception {
        try {
            System.out.println("running server");
            this.run();
            System.out.println("signal ready");
            this.ready();
            System.in.read();
            System.out.println("stopping bus");
            this.tearDown();
        }
        catch (Throwable ex) {
            this.startFailed();
            throw ex;
        }
        finally {
            if (this.verify(this.getLog())) {
                System.out.println("server passed");
            } else {
                System.out.println("server startup failed (not a log message)");
            }
            System.out.println("server stopped");
        }
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    protected void ready() {
        if (!this.inProcess) {
            System.out.println("server ready");
        }
    }

    protected void startFailed() {
        System.out.println("server startup failed (not a log message)");
    }

    protected boolean verify(Logger log) {
        return true;
    }

    protected static int allocatePortAsInt(Class<?> cls) {
        return Integer.parseInt(TestUtil.getPortNumber(cls));
    }

    protected static String allocatePort(Class<?> cls) {
        return TestUtil.getPortNumber(cls);
    }

    protected static String allocatePort(Class<?> cls, int i) {
        return TestUtil.getPortNumber(cls, i);
    }
}

