/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.recorders;

import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.io.WriteOnCloseOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class OutMessageRecorder
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getLogger(OutMessageRecorder.class);
    private final List<byte[]> outbound = new CopyOnWriteArrayList<byte[]>();

    public OutMessageRecorder() {
        super("prepare-send");
        this.addAfter(MessageSenderInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        if (null == os) {
            return;
        }
        WriteOnCloseOutputStream stream = OutMessageRecorder.createCachedStream(message, os);
        stream.registerCallback((CachedOutputStreamCallback)new RecorderCallback());
    }

    public static WriteOnCloseOutputStream createCachedStream(Message message, OutputStream os) {
        if (!(os instanceof WriteOnCloseOutputStream)) {
            WriteOnCloseOutputStream cached = new WriteOnCloseOutputStream(os);
            message.setContent(OutputStream.class, (Object)cached);
            os = cached;
        }
        return (WriteOnCloseOutputStream)os;
    }

    public List<byte[]> getOutboundMessages() {
        return this.outbound;
    }

    class RecorderCallback
    implements CachedOutputStreamCallback {
        RecorderCallback() {
        }

        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            try {
                OutMessageRecorder.this.outbound.add(cos.getBytes());
            }
            catch (Exception e) {
                LOG.fine("Can't record message from output stream class: " + cos.getOut().getClass().getName());
            }
        }
    }
}

