/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hello_world_mixedstyle;

import jakarta.jws.WebService;
import org.apache.hello_world_mixedstyle.Greeter;
import org.apache.hello_world_mixedstyle.PingMeFault;
import org.apache.hello_world_mixedstyle.types.FaultDetail;
import org.apache.hello_world_mixedstyle.types.GreetMe1;
import org.apache.hello_world_mixedstyle.types.GreetMeResponse;

@WebService(serviceName="SOAPService", portName="SoapPort", endpointInterface="org.apache.hello_world_mixedstyle.Greeter", targetNamespace="http://apache.org/hello_world_mixedstyle", wsdlLocation="testutils/hello_world_mixedstyle.wsdl")
public class GreeterImplMixedStyle
implements Greeter {
    private String version;

    public GreeterImplMixedStyle() {
        this.version = "";
    }

    public GreeterImplMixedStyle(String v) {
        this.version = v;
    }

    @Override
    public String sayHi() {
        System.out.println("Call sayHi here ");
        return "Bonjour" + this.version;
    }

    @Override
    public GreetMeResponse greetMe(GreetMe1 requestType) {
        System.out.println("Call greetMe here: " + requestType.getRequestType());
        GreetMeResponse response = new GreetMeResponse();
        response.setResponseType("Hello " + requestType.getRequestType() + this.version);
        return response;
    }

    @Override
    public void greetMeOneWay(String requestType) {
        System.out.println("*********  greetMeOneWay: " + requestType);
    }

    @Override
    public void pingMe() throws PingMeFault {
        FaultDetail faultDetail = new FaultDetail();
        faultDetail.setMajor((short)2);
        faultDetail.setMinor((short)1);
        throw new PingMeFault("PingMeFault raised by server", faultDetail);
    }
}

