/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.recorders;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class InMessageRecorder
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getLogger(InMessageRecorder.class);
    private final List<byte[]> inbound = new CopyOnWriteArrayList<byte[]>();

    public InMessageRecorder() {
        super("receive");
    }

    public void handleMessage(Message message) throws Fault {
        try (InputStream is = (InputStream)message.getContent(InputStream.class);){
            if (is != null) {
                int i = is.available();
                if (i < 4096) {
                    i = 4096;
                }
                LoadingByteArrayOutputStream bout = new LoadingByteArrayOutputStream(i);
                IOUtils.copy((InputStream)is, (OutputStream)bout);
                is.close();
                this.inbound.add(bout.toByteArray());
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("inbound: " + new String(bout.toByteArray()));
                }
                message.setContent(InputStream.class, (Object)bout.createInputStream());
            }
        }
        catch (Exception ex) {
            throw new Fault((Throwable)ex);
        }
    }

    public List<byte[]> getInboundMessages() {
        return this.inbound;
    }
}

