/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hello_world_soap_http;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import org.apache.hello_world_soap_http.BadRecordLitFault;
import org.apache.hello_world_soap_http.DerivedGreeterImpl;
import org.apache.hello_world_soap_http.GreeterEndpointInterface;
import org.apache.hello_world_soap_http.NoSuchCodeLitFault;
import org.apache.hello_world_soap_http.types.BareDocumentResponse;
import org.apache.hello_world_soap_http.types.GreetMeLaterResponse;
import org.apache.hello_world_soap_http.types.GreetMeResponse;
import org.apache.hello_world_soap_http.types.GreetMeSometimeResponse;
import org.apache.hello_world_soap_http.types.SayHiResponse;
import org.apache.hello_world_soap_http.types.TestDocLitFaultResponse;
import org.apache.hello_world_soap_http.types.TestNillableResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(endpointInterface="org.apache.hello_world_soap_http.Greeter", wsdlLocation="tetutils/hello_world.wsdl")
public class AnotherDerivedGreeterImpl
implements GreeterEndpointInterface {
    private static final Logger LOG = Logger.getLogger(DerivedGreeterImpl.class.getName());
    private final Map<String, Integer> invocationCount = new HashMap<String, Integer>();

    public AnotherDerivedGreeterImpl() {
        this.invocationCount.put("sayHi", 0);
        this.invocationCount.put("greetMe", 0);
        this.invocationCount.put("greetMeLater", 0);
        this.invocationCount.put("greetMeOneWay", 0);
        this.invocationCount.put("overloadedSayHi", 0);
    }

    public int getInvocationCount(String method) {
        if (this.invocationCount.containsKey(method)) {
            return this.invocationCount.get(method);
        }
        System.out.println("No invocation count for method: " + method);
        return 0;
    }

    public String sayHi(String me) throws RemoteException {
        this.incrementInvocationCount("overloadedSayHi");
        return "Hi " + me + "!";
    }

    @Override
    @WebMethod(operationName="sayHi")
    public String sayHi() {
        this.incrementInvocationCount("sayHi");
        return "Hi";
    }

    @Override
    public void testDocLitFault(String faultType) throws BadRecordLitFault, NoSuchCodeLitFault {
    }

    @Override
    public Response<TestDocLitFaultResponse> testDocLitFaultAsync(String faultType) {
        return null;
    }

    public Response<TestDocLitFaultResponse> testDocLitFaultAsync(String faultType, AsyncHandler<TestDocLitFaultResponse> ah) {
        return null;
    }

    @Override
    public String greetMe(String me) {
        this.incrementInvocationCount("greetMe");
        return "Bonjour " + me + "!";
    }

    @Override
    public String greetMeLater(long delay) {
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.incrementInvocationCount("greetMeLater");
        return "Hello, finally!";
    }

    @Override
    public String greetMeSometime(String me) {
        this.incrementInvocationCount("greetMeSometime");
        return "Hello there " + me + "!";
    }

    @Override
    public Future<?> greetMeSometimeAsync(String requestType, AsyncHandler<GreetMeSometimeResponse> asyncHandler) {
        return null;
    }

    @Override
    public Response<GreetMeSometimeResponse> greetMeSometimeAsync(String requestType) {
        return null;
    }

    @Override
    public Future<?> greetMeAsync(String requestType, AsyncHandler<GreetMeResponse> asyncHandler) {
        return null;
    }

    @Override
    public Response<GreetMeResponse> greetMeAsync(String requestType) {
        return null;
    }

    @Override
    public Future<?> greetMeLaterAsync(long requestType, AsyncHandler<GreetMeLaterResponse> asyncHandler) {
        return null;
    }

    @Override
    public Response<GreetMeLaterResponse> greetMeLaterAsync(long requestType) {
        return null;
    }

    @Override
    public Future<?> sayHiAsync(AsyncHandler<SayHiResponse> asyncHandler) {
        return null;
    }

    @Override
    public Response<SayHiResponse> sayHiAsync() {
        return null;
    }

    public Future<?> testDocLitBareAsync(String in, AsyncHandler<BareDocumentResponse> asyncHandler) {
        return null;
    }

    public Response<BareDocumentResponse> testDocLitBareAsync(String in) {
        return null;
    }

    @Override
    public void greetMeOneWay(String me) {
        this.incrementInvocationCount("greetMeOneWay");
    }

    public BareDocumentResponse testDocLitBare(String in) {
        this.incrementInvocationCount("testDocLitBare");
        BareDocumentResponse res = new BareDocumentResponse();
        res.setCompany("CXF");
        res.setId(1);
        return res;
    }

    private void incrementInvocationCount(String method) {
        LOG.info("Executing " + method);
        int n = this.invocationCount.get(method);
        this.invocationCount.put(method, n + 1);
    }

    @Override
    public String testNillable(String nillElem, int intElem) {
        return null;
    }

    @Override
    public Response<TestNillableResponse> testNillableAsync(String nillElem, int intElem) {
        return null;
    }

    @Override
    public Future<?> testNillableAsync(String nillElem, int intElem, AsyncHandler<TestNillableResponse> asyncHandler) {
        return null;
    }
}

