/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.AsymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Binding;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.cxf.ws.security.policy.model.TransportBinding;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AsymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.SymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.TransportBindingHandler;
import org.apache.ws.security.message.WSSecHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyBasedWSS4JOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public static final String SECURITY_PROCESSED = PolicyBasedWSS4JOutInterceptor.class.getName() + ".DONE";
    public static final PolicyBasedWSS4JOutInterceptor INSTANCE = new PolicyBasedWSS4JOutInterceptor();
    private PolicyBasedWSS4JOutInterceptorInternal ending;
    private SAAJOutInterceptor saajOut = new SAAJOutInterceptor();

    public PolicyBasedWSS4JOutInterceptor() {
        super("pre-protocol");
        this.getAfter().add(SAAJOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    public void handleMessage(SoapMessage mc) throws Fault {
        if (mc.getContent(SOAPMessage.class) == null) {
            this.saajOut.handleMessage(mc);
        }
        mc.put(SECURITY_PROCESSED, (Object)Boolean.TRUE);
        mc.getInterceptorChain().add((Interceptor)this.ending);
    }

    public void handleFault(SoapMessage message) {
        this.saajOut.handleFault(message);
    }

    public final PolicyBasedWSS4JOutInterceptorInternal createEndingInterceptor() {
        return new PolicyBasedWSS4JOutInterceptorInternal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PolicyBasedWSS4JOutInterceptorInternal
    implements PhaseInterceptor<SoapMessage> {
        public void handleMessage(SoapMessage message) throws Fault {
            SOAPMessage saaj = (SOAPMessage)message.getContent(SOAPMessage.class);
            boolean mustUnderstand = true;
            String actor = null;
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim != null) {
                Binding transport = null;
                Collection ais = (Collection)aim.get((Object)SP12Constants.TRANSPORT_BINDING);
                if (ais != null) {
                    for (AssertionInfo ai : ais) {
                        transport = (Binding)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                }
                if ((ais = (Collection)aim.get((Object)SP12Constants.ASYMMETRIC_BINDING)) != null) {
                    for (AssertionInfo ai : ais) {
                        transport = (Binding)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                }
                if ((ais = (Collection)aim.get((Object)SP12Constants.SYMMETRIC_BINDING)) != null) {
                    for (AssertionInfo ai : ais) {
                        transport = (Binding)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                }
                if (transport == null && PolicyBasedWSS4JOutInterceptor.this.isRequestor((Message)message)) {
                    transport = new TransportBinding(SP12Constants.INSTANCE);
                }
                if (transport != null) {
                    WSSecHeader secHeader = new WSSecHeader(actor, mustUnderstand);
                    Element el = secHeader.insertSecurityHeader((Document)saaj.getSOAPPart());
                    try {
                        saaj.getSOAPHeader().removeChild((Node)el);
                        saaj.getSOAPHeader().appendChild((Node)el);
                    }
                    catch (SOAPException e) {
                        // empty catch block
                    }
                    if (transport instanceof TransportBinding) {
                        new TransportBindingHandler((TransportBinding)transport, saaj, secHeader, aim, message).handleBinding();
                    } else if (transport instanceof SymmetricBinding) {
                        new SymmetricBindingHandler((SymmetricBinding)transport, saaj, secHeader, aim, message).handleBinding();
                    } else {
                        new AsymmetricBindingHandler((AsymmetricBinding)transport, saaj, secHeader, aim, message).handleBinding();
                    }
                    if (el.getFirstChild() == null) {
                        el.getParentNode().removeChild(el);
                    }
                }
                if ((ais = (Collection)aim.get((Object)SP12Constants.WSS10)) != null) {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
                if ((ais = (Collection)aim.get((Object)SP12Constants.WSS11)) != null) {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }

        public Set<String> getAfter() {
            return Collections.emptySet();
        }

        public Set<String> getBefore() {
            return Collections.emptySet();
        }

        public String getId() {
            return PolicyBasedWSS4JOutInterceptorInternal.class.getName();
        }

        public String getPhase() {
            return "post-protocol";
        }

        public void handleFault(SoapMessage message) {
        }
    }
}

