/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.java5;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AbstractTypeCreator;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeClassInfo;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.basic.BeanType;
import org.apache.cxf.aegis.type.java5.AnnotatedTypeInfo;
import org.apache.cxf.aegis.type.java5.AnnotationReader;
import org.apache.cxf.aegis.type.java5.EnumType;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.aegis.util.ServiceUtils;
import org.apache.cxf.common.logging.LogUtils;

public class Java5TypeCreator
extends AbstractTypeCreator {
    private static final Logger LOG = LogUtils.getL7dLogger(Java5TypeCreator.class);
    private AnnotationReader annotationReader;

    public Java5TypeCreator() {
        this(new AnnotationReader());
    }

    public Java5TypeCreator(AnnotationReader annotationReader) {
        this.annotationReader = annotationReader;
    }

    public static Class<? extends AegisType> castToAegisTypeClass(Class<?> c) {
        if (c == null) {
            return null;
        }
        if (AegisType.class.isAssignableFrom(c)) {
            return c.asSubclass(AegisType.class);
        }
        throw new DatabindingException("Invalid Aegis type annotation to non-type class" + c);
    }

    @Override
    public TypeClassInfo createClassInfo(Method m, int index) {
        TypeClassInfo info;
        if (index >= 0) {
            TypeClassInfo info2;
            Type genericType = m.getGenericParameterTypes()[index];
            if (genericType instanceof Class) {
                info2 = this.nextCreator.createClassInfo(m, index);
            } else {
                info2 = new TypeClassInfo();
                info2.setDescription("method " + m.getName() + " parameter " + index);
                info2.setType(genericType);
            }
            Class<?> paramTypeClass = this.annotationReader.getParamType(m, index);
            info2.setAegisTypeClass(Java5TypeCreator.castToAegisTypeClass(paramTypeClass));
            String paramName = this.annotationReader.getParamTypeName(m, index);
            if (paramName != null) {
                info2.setTypeName(this.createQName(m.getParameterTypes()[index], genericType, paramName, this.annotationReader.getParamNamespace(m, index)));
            }
            return info2;
        }
        Type genericReturnType = m.getGenericReturnType();
        if (genericReturnType instanceof Class) {
            info = this.nextCreator.createClassInfo(m, index);
        } else {
            info = new TypeClassInfo();
            info.setDescription("method " + m.getName() + " parameter " + index);
            info.setType(genericReturnType);
        }
        if (m.getParameterAnnotations() != null && m.getAnnotations().length > 0) {
            info.setAnnotations(m.getAnnotations());
        }
        info.setAegisTypeClass(Java5TypeCreator.castToAegisTypeClass(this.annotationReader.getReturnType(m)));
        String returnName = this.annotationReader.getReturnTypeName(m);
        if (returnName != null) {
            info.setTypeName(this.createQName(m.getReturnType(), genericReturnType, returnName, this.annotationReader.getReturnNamespace(m)));
        }
        return info;
    }

    @Override
    public TypeClassInfo createClassInfo(PropertyDescriptor pd) {
        Type genericType = pd.getReadMethod().getGenericReturnType();
        TypeClassInfo info = this.createBasicClassInfo(pd.getPropertyType());
        info.setType(genericType);
        info.setAnnotations(pd.getReadMethod().getAnnotations());
        info.setAegisTypeClass(Java5TypeCreator.castToAegisTypeClass(this.annotationReader.getType(pd.getReadMethod())));
        info.setFlat(this.annotationReader.isFlat(pd.getReadMethod().getAnnotations()));
        return info;
    }

    @Override
    public AegisType createCollectionType(TypeClassInfo info) {
        Type type = info.getType();
        Type componentType = this.getComponentType(type, 0);
        if (componentType != null) {
            return this.createCollectionTypeFromGeneric(info);
        }
        return this.nextCreator.createCollectionType(info);
    }

    @Override
    protected AegisType getOrCreateGenericType(TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info, 0, false);
    }

    @Override
    protected AegisType getOrCreateMapKeyType(TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info, 0, true);
    }

    @Override
    protected AegisType getOrCreateMapValueType(TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info, 1, true);
    }

    protected AegisType getOrCreateParameterizedType(TypeClassInfo generic, int index, boolean map) {
        Type paramType;
        Map<String, Type> pm = generic.getTypeVars();
        if (map) {
            pm = pm == null ? new HashMap<String, Type>() : new HashMap<String, Type>(pm);
            paramType = this.getComponentTypeForMap(generic.getType(), pm, index == 0);
        } else {
            paramType = this.getComponentType(generic.getType(), index);
        }
        if (paramType instanceof WildcardType) {
            WildcardType wct = (WildcardType)paramType;
            paramType = wct.getUpperBounds()[0];
        }
        if (paramType instanceof TypeVariable) {
            TypeVariable v = (TypeVariable)paramType;
            LOG.log(Level.WARNING, "Could not map TypeVariable named {0} from {1} with initial mapping {2} to a known class.  Using Object.", new Object[]{v.getName(), generic.getType().toString(), generic.getTypeVars()});
        }
        if (paramType == null) {
            return this.createObjectType();
        }
        Class<?> clazz = TypeUtil.getTypeRelatedClass(paramType);
        if (clazz == null) {
            return this.createObjectType();
        }
        if (!Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz)) {
            return this.getTopCreator().createType(clazz);
        }
        TypeClassInfo info = this.createBasicClassInfo(clazz);
        info.setDescription(clazz.toString());
        info.setType(paramType, paramType instanceof ParameterizedType ? pm : null);
        return this.createTypeForClass(info);
    }

    protected Type getComponentType(Type genericType, int index) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericType;
            Type paramType = type.getActualTypeArguments()[index];
            if (paramType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)paramType;
                return wildcardType.getUpperBounds()[0];
            }
            return paramType;
        }
        return null;
    }

    protected Type getComponentTypeForMap(Type genericType, Map<String, Type> pm, boolean key) {
        if (pm == null) {
            pm = new HashMap<String, Type>();
        }
        return this.findMapGenericTypes(genericType, pm, key);
    }

    private Type findMapGenericTypes(Type cls, Map<String, Type> pm, boolean key) {
        Class c;
        if (cls == null) {
            return null;
        }
        if (cls instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)cls;
            Type[] types = pt.getActualTypeArguments();
            TypeVariable<Class<T>>[] params = ((Class)pt.getRawType()).getTypeParameters();
            for (int x = 0; x < types.length; ++x) {
                TypeVariable tv;
                Type type = types[x];
                if (type instanceof TypeVariable && pm.containsKey((tv = (TypeVariable)types[x]).getName())) {
                    types[x] = type = pm.get(tv.getName());
                }
                pm.put(params[x].getName(), type);
            }
            if (Map.class.equals((Object)pt.getRawType())) {
                return types[key ? 0 : 1];
            }
            return this.findMapGenericTypes(pt.getRawType(), pm, key);
        }
        if (cls instanceof Class && Map.class.isAssignableFrom(c = (Class)cls)) {
            for (Type tp : c.getGenericInterfaces()) {
                HashMap<String, Type> cp = new HashMap<String, Type>(pm);
                Type types = this.findMapGenericTypes(tp, cp, key);
                if (types == null) continue;
                pm.putAll(cp);
                return types;
            }
            if (c.getSuperclass() != null && Map.class.isAssignableFrom(c.getSuperclass())) {
                return this.findMapGenericTypes(c.getGenericSuperclass(), pm, key);
            }
        }
        return null;
    }

    @Override
    public AegisType createDefaultType(TypeClassInfo info) {
        QName typeName = info.getTypeName();
        Class<?> relatedClass = TypeUtil.getTypeRelatedClass(info.getType());
        if (typeName == null) {
            typeName = this.createQName(relatedClass);
        }
        AnnotatedTypeInfo typeInfo = new AnnotatedTypeInfo(this.getTypeMapping(), relatedClass, typeName.getNamespaceURI(), this.getConfiguration());
        typeInfo.setExtensibleElements(this.annotationReader.isExtensibleElements(relatedClass, this.getConfiguration().isDefaultExtensibleElements()));
        typeInfo.setExtensibleAttributes(this.annotationReader.isExtensibleAttributes(relatedClass, this.getConfiguration().isDefaultExtensibleAttributes()));
        typeInfo.setDefaultMinOccurs(this.getConfiguration().getDefaultMinOccurs());
        typeInfo.setDefaultNillable(this.getConfiguration().isDefaultNillable());
        BeanType type = new BeanType(typeInfo);
        type.setTypeMapping(this.getTypeMapping());
        type.setSchemaType(typeName);
        return type;
    }

    @Override
    public AegisType createEnumType(TypeClassInfo info) {
        EnumType type = new EnumType();
        type.setSchemaType(this.createQName(TypeUtil.getTypeRelatedClass(info.getType())));
        type.setTypeClass(info.getType());
        type.setTypeMapping(this.getTypeMapping());
        return type;
    }

    @Override
    public QName createQName(Class<?> typeClass) {
        String name = this.annotationReader.getName(typeClass);
        String ns = this.annotationReader.getNamespace(typeClass);
        return this.createQName(typeClass, null, name, ns);
    }

    private QName createQName(Class<?> typeClass, Type type, String name, String ns) {
        if (typeClass.isArray()) {
            typeClass = typeClass.getComponentType();
        }
        if (List.class.isAssignableFrom(typeClass) && type instanceof ParameterizedType && (type = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
            typeClass = (Class)type;
        }
        if (name == null || name.length() == 0) {
            name = ServiceUtils.makeServiceNameFromClassName(typeClass);
        }
        if (ns == null || ns.length() == 0) {
            ns = this.annotationReader.getNamespace(typeClass);
        }
        if (ns == null || ns.length() == 0) {
            ns = this.annotationReader.getNamespace(typeClass.getPackage());
        }
        if (ns == null || ns.length() == 0) {
            ns = NamespaceHelper.makeNamespaceFromClassName(typeClass.getName(), "http");
        }
        return new QName(ns, name);
    }

    @Override
    protected boolean isEnum(Class<?> javaType) {
        return javaType.isEnum();
    }
}

