/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.CommandInterfaceUtils;
import org.apache.cxf.tools.java2ws.JavaToWS;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class Java2WSMojo
extends AbstractMojo {
    private String className;
    private String classpath;
    private String outputFile;
    private Boolean soap12;
    private String targetNamespace;
    private String serviceName;
    private Boolean verbose;
    private Boolean quiet;
    private List classpathElements;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private String argline;
    private String frontend;
    private String databinding;
    private Boolean genWsdl;
    private Boolean genServer;
    private Boolean genClient;
    private Boolean genWrapperbean;
    private Boolean attachWsdl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        StringBuilder buf = new StringBuilder();
        for (Object classpathElement : this.classpathElements) {
            buf.append(classpathElement.toString());
            buf.append(File.pathSeparatorChar);
        }
        String newCp = buf.toString();
        String cp = System.getProperty("java.class.path");
        try {
            System.setProperty("java.class.path", newCp);
            this.processJavaClass();
        }
        finally {
            System.setProperty("java.class.path", cp);
        }
        System.gc();
    }

    private void processJavaClass() throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        if (this.outputFile == null && this.project != null) {
            int i = this.className.lastIndexOf(46);
            String name = this.className.substring(i + 1);
            this.outputFile = (this.project.getBuild().getDirectory() + "/generated/wsdl/" + name + ".wsdl").replace("/", File.separator);
        }
        if (this.outputFile != null) {
            FileUtils.mkDir((File)new File(this.outputFile).getParentFile());
            args.add("-o");
            args.add(this.outputFile);
            if (this.project != null) {
                this.project.addCompileSourceRoot(new File(this.outputFile).getParentFile().getAbsolutePath());
            }
        }
        if (this.frontend != null) {
            args.add("-frontend");
            args.add(this.frontend);
        }
        if (this.databinding != null) {
            args.add("-databinding");
            args.add(this.databinding);
        }
        if (this.genWrapperbean.booleanValue()) {
            args.add("-wrapperbean");
        }
        if (this.genWsdl.booleanValue()) {
            args.add("-wsdl");
        }
        if (this.genServer.booleanValue()) {
            args.add("-server");
        }
        if (this.genClient.booleanValue()) {
            args.add("-client");
        }
        args.add("-cp");
        args.add(this.classpath);
        if (this.soap12 != null && this.soap12.booleanValue()) {
            args.add("-soap12");
        }
        if (this.targetNamespace != null) {
            args.add("-t");
            args.add(this.targetNamespace);
        }
        if (this.serviceName != null) {
            args.add("-servicename");
            args.add(this.serviceName);
        }
        if (this.verbose != null && this.verbose.booleanValue()) {
            args.add("-verbose");
        }
        if (this.quiet != null && this.quiet.booleanValue()) {
            args.add("-quiet");
        }
        if (this.argline != null) {
            StringTokenizer stoken = new StringTokenizer(this.argline, " ");
            while (stoken.hasMoreTokens()) {
                args.add(stoken.nextToken());
            }
        }
        args.add(this.className);
        try {
            CommandInterfaceUtils.commandCommonMain();
            JavaToWS j2w = new JavaToWS(args.toArray(new String[args.size()]));
            j2w.run();
        }
        catch (Throwable e) {
            this.getLog().debug(e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (this.attachWsdl.booleanValue() && this.outputFile != null) {
            File wsdlFile = new File(this.outputFile);
            this.projectHelper.attachArtifact(this.project, "wsdl", wsdlFile);
        }
    }
}

