/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry.jaxrs;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentelemetry.AbstractOpenTelemetryClientProvider;
import org.apache.cxf.tracing.opentelemetry.TraceScope;

@Provider
public class OpenTelemetryClientProvider
extends AbstractOpenTelemetryClientProvider
implements ClientRequestFilter,
ClientResponseFilter {
    public OpenTelemetryClientProvider(OpenTelemetry openTelemetry, String instrumentationName) {
        super(openTelemetry, instrumentationName);
    }

    public OpenTelemetryClientProvider(OpenTelemetry openTelemetry, Tracer tracer) {
        super(openTelemetry, tracer);
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan((Map<String, List<String>>)requestContext.getStringHeaders(), requestContext.getUri(), requestContext.getMethod());
        if (holder != null) {
            requestContext.setProperty("org.apache.cxf.tracing.client.opentelemetry.span", holder);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        AbstractTracingProvider.TraceScopeHolder holder = (AbstractTracingProvider.TraceScopeHolder)requestContext.getProperty("org.apache.cxf.tracing.client.opentelemetry.span");
        super.stopTraceSpan((AbstractTracingProvider.TraceScopeHolder<TraceScope>)holder, responseContext.getStatus());
    }
}

