/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.micrometer.jaxrs;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.apache.cxf.jaxrs.ext.Nullable;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.micrometer.AbstractObservationClientProvider;
import org.apache.cxf.tracing.micrometer.ObservationScope;
import org.apache.cxf.tracing.micrometer.jaxrs.ContainerRequestSenderObservationContext;
import org.apache.cxf.tracing.micrometer.jaxrs.ContainerRequestSenderObservationConvention;
import org.apache.cxf.tracing.micrometer.jaxrs.DefaultContainerRequestSenderObservationConvention;
import org.apache.cxf.tracing.micrometer.jaxrs.JaxrsObservationDocumentation;

@Provider
public class ObservationClientProvider
extends AbstractObservationClientProvider
implements ClientRequestFilter,
ClientResponseFilter {
    private final ContainerRequestSenderObservationConvention convention;

    public ObservationClientProvider(ObservationRegistry observationRegistry) {
        this(observationRegistry, null);
    }

    public ObservationClientProvider(ObservationRegistry observationRegistry, @Nullable ContainerRequestSenderObservationConvention convention) {
        super(observationRegistry);
        this.convention = convention;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        ContainerRequestSenderObservationContext senderContext = new ContainerRequestSenderObservationContext(requestContext);
        Observation observation = JaxrsObservationDocumentation.OUT_OBSERVATION.start(this.convention, DefaultContainerRequestSenderObservationConvention.INSTANCE, () -> senderContext, this.getObservationRegistry());
        AbstractTracingProvider.TraceScopeHolder<ObservationScope> holder = super.startScopedObservation(observation);
        if (holder != null) {
            requestContext.setProperty("org.apache.cxf.tracing.client.micrometer.observation", holder);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        AbstractTracingProvider.TraceScopeHolder holder = (AbstractTracingProvider.TraceScopeHolder)requestContext.getProperty("org.apache.cxf.tracing.client.micrometer.observation");
        super.stopTraceSpan((AbstractTracingProvider.TraceScopeHolder<ObservationScope>)holder, null, observation -> {
            ContainerRequestSenderObservationContext context = (ContainerRequestSenderObservationContext)observation.getContext();
            context.setResponse(responseContext);
        });
    }
}

