/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave.internal;

import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import java.net.URI;
import java.util.List;
import org.apache.cxf.tracing.brave.internal.HttpAdapterFactory;

public interface HttpClientAdapterFactory
extends HttpAdapterFactory {
    public static HttpClientRequest create(final HttpAdapterFactory.Request request) {
        return new HttpClientRequest(){

            public String method() {
                return request.method();
            }

            public String path() {
                return request.uri().getPath();
            }

            public String route() {
                return this.path();
            }

            public String url() {
                return request.uri().toString();
            }

            public String header(String name) {
                List<String> value = request.headers().get(name);
                return value != null && !value.isEmpty() ? value.get(0) : null;
            }

            public HttpAdapterFactory.Request unwrap() {
                return request;
            }

            public void header(String name, String value) {
                request.headers().put(name, List.of(value));
            }
        };
    }

    public static HttpClientResponse create(final HttpAdapterFactory.Response response) {
        return new HttpClientResponse(){

            public String route() {
                return response.path();
            }

            public int statusCode() {
                return response.status();
            }

            public HttpAdapterFactory.Response unwrap() {
                return response;
            }

            public String method() {
                return response.method();
            }
        };
    }

    public static HttpClientResponse create(final String method, final URI uri, final Throwable ex) {
        return new HttpClientResponse(){

            public Throwable unwrap() {
                return ex;
            }

            public String method() {
                return method;
            }

            public String route() {
                return uri.toASCIIString();
            }

            public int statusCode() {
                return 0;
            }

            public Throwable error() {
                return ex;
            }
        };
    }
}

