/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.transaction.xa.XAResource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.core.resourceadapter.ResourceBean;
import org.apache.cxf.jca.inbound.InboundEndpoint;
import org.apache.cxf.jca.inbound.MDBActivationSpec;
import org.apache.cxf.jca.inbound.MDBActivationWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAdapterImpl
extends ResourceBean
implements ResourceAdapter {
    private static final Logger LOG = LogUtils.getL7dLogger(ResourceAdapterImpl.class);
    private BootstrapContext ctx;
    private Set<Bus> busCache = new HashSet<Bus>();
    private Map<String, InboundEndpoint> endpoints = new ConcurrentHashMap<String, InboundEndpoint>();

    public ResourceAdapterImpl() {
    }

    public ResourceAdapterImpl(Properties props) {
        super(props);
    }

    public void registerBus(Bus bus) {
        LOG.fine("Bus " + bus + " initialized and added to ResourceAdapter busCache");
        this.busCache.add(bus);
    }

    protected Set getBusCache() {
        return this.busCache;
    }

    protected void setBusCache(Set<Bus> cache) {
        this.busCache = cache;
    }

    public void start(BootstrapContext aCtx) throws ResourceAdapterInternalException {
        LOG.fine("Resource Adapter is starting by appserver...");
        if (aCtx == null) {
            throw new ResourceAdapterInternalException("BootstrapContext can not be null");
        }
        this.ctx = aCtx;
    }

    public void stop() {
        LOG.fine("Resource Adapter is being stopped by appserver...");
        if (!this.busCache.isEmpty()) {
            Iterator<Bus> busIterator = this.busCache.iterator();
            Bus bus = null;
            while (busIterator.hasNext()) {
                bus = busIterator.next();
                bus.shutdown(true);
            }
        }
        for (Map.Entry<String, InboundEndpoint> entry : this.endpoints.entrySet()) {
            try {
                entry.getValue().shutdown();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to stop endpoint " + entry.getKey(), e);
            }
        }
        this.endpoints.clear();
    }

    public XAResource[] getXAResources(ActivationSpec[] as) throws ResourceException {
        throw new NotSupportedException();
    }

    public void endpointActivation(MessageEndpointFactory mef, ActivationSpec as) throws ResourceException {
        if (!(as instanceof MDBActivationSpec)) {
            LOG.fine("Ignored unknown activation spec " + as);
            return;
        }
        MDBActivationSpec spec = (MDBActivationSpec)as;
        LOG.info("CXF resource adapter is activating " + spec.getDisplayName());
        MDBActivationWork work = new MDBActivationWork(spec, mef, this.endpoints);
        this.ctx.getWorkManager().scheduleWork((Work)work);
    }

    public void endpointDeactivation(MessageEndpointFactory mef, ActivationSpec as) {
        if (!(as instanceof MDBActivationSpec)) {
            LOG.fine("Ignored unknown activation spec " + as);
            return;
        }
        MDBActivationSpec spec = (MDBActivationSpec)as;
        LOG.info("CXF resource adapter is deactivating " + spec.getDisplayName());
        InboundEndpoint endpoint = this.endpoints.remove(spec.getDisplayName());
        if (endpoint != null) {
            try {
                endpoint.shutdown();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to stop endpoint " + spec.getDisplayName(), e);
            }
        }
    }

    public BootstrapContext getBootstrapContext() {
        return this.ctx;
    }
}

