/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyhandlers;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AbstractStaxBindingHandler;
import org.apache.neethi.Assertion;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractBinding;
import org.apache.wss4j.policy.model.AbstractSymmetricAsymmetricBinding;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.AbstractTokenWrapper;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.model.IssuedToken;
import org.apache.wss4j.policy.model.KerberosToken;
import org.apache.wss4j.policy.model.SecureConversationToken;
import org.apache.wss4j.policy.model.SecurityContextToken;
import org.apache.wss4j.policy.model.SpnegoContextToken;
import org.apache.wss4j.policy.model.SymmetricBinding;
import org.apache.wss4j.policy.model.UsernameToken;
import org.apache.wss4j.policy.model.X509Token;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.SecurePart;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.stax.securityEvent.AbstractSecuredElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;

public class StaxSymmetricBindingHandler
extends AbstractStaxBindingHandler {
    private SymmetricBinding sbinding;
    private SoapMessage message;

    public StaxSymmetricBindingHandler(Map<String, Object> properties, SoapMessage msg, SymmetricBinding sbinding, Map<String, SecurityTokenProvider<OutboundSecurityToken>> outboundTokens) {
        super(properties, msg, (AbstractBinding)sbinding, outboundTokens);
        this.message = msg;
        this.sbinding = sbinding;
    }

    private AbstractTokenWrapper getSignatureToken() {
        if (this.sbinding.getProtectionToken() != null) {
            return this.sbinding.getProtectionToken();
        }
        return this.sbinding.getSignatureToken();
    }

    private AbstractTokenWrapper getEncryptionToken() {
        if (this.sbinding.getProtectionToken() != null) {
            return this.sbinding.getProtectionToken();
        }
        return this.sbinding.getEncryptionToken();
    }

    public void handleBinding() {
        AssertionInfoMap aim = this.getMessage().get(AssertionInfoMap.class);
        this.configureTimestamp(aim);
        this.assertPolicy(this.sbinding.getName());
        String asymSignatureAlgorithm = (String)this.getMessage().getContextualProperty("ws-security.asymmetric.signature.algorithm");
        if (asymSignatureAlgorithm != null && this.sbinding.getAlgorithmSuite() != null) {
            this.sbinding.getAlgorithmSuite().setAsymmetricSignature(asymSignatureAlgorithm);
        }
        Map<String, Object> config = this.getProperties();
        AbstractStaxBindingHandler.TokenStoreCallbackHandler callbackHandler = new AbstractStaxBindingHandler.TokenStoreCallbackHandler((CallbackHandler)config.get("passwordCallbackRef"), WSS4JUtils.getTokenStore(this.message));
        config.put("passwordCallbackRef", callbackHandler);
        if (this.sbinding.getProtectionOrder() == AbstractSymmetricAsymmetricBinding.ProtectionOrder.EncryptBeforeSigning) {
            this.doEncryptBeforeSign();
            this.assertPolicy(new QName(this.sbinding.getName().getNamespaceURI(), "EncryptBeforeSigning"));
        } else {
            this.doSignBeforeEncrypt();
            this.assertPolicy(new QName(this.sbinding.getName().getNamespaceURI(), "SignBeforeEncrypting"));
        }
        if (!this.isRequestor()) {
            config.put("encryptSymmetricEncryptionKey", "false");
        }
        this.configureLayout(aim);
        this.assertAlgorithmSuite(this.sbinding.getAlgorithmSuite());
        this.assertWSSProperties(this.sbinding.getName().getNamespaceURI());
        this.assertTrustProperties(this.sbinding.getName().getNamespaceURI());
        this.assertPolicy(new QName(this.sbinding.getName().getNamespaceURI(), "OnlySignEntireHeadersAndBody"));
        if (this.sbinding.isProtectTokens()) {
            this.assertPolicy(new QName(this.sbinding.getName().getNamespaceURI(), "ProtectTokens"));
        }
    }

    private void doEncryptBeforeSign() {
        try {
            SecurePart part;
            org.apache.xml.security.stax.securityToken.SecurityToken securityToken;
            AbstractTokenWrapper encryptionWrapper = this.getEncryptionToken();
            this.assertTokenWrapper(encryptionWrapper);
            AbstractToken encryptionToken = encryptionWrapper.getToken();
            String tokenId = null;
            SecurityToken tok = null;
            if (encryptionToken instanceof KerberosToken) {
                tok = this.getSecurityToken();
                if (MessageUtils.isRequestor(this.message)) {
                    this.addKerberosToken((KerberosToken)encryptionToken, false, true, true);
                }
            } else if (encryptionToken instanceof IssuedToken) {
                tok = this.getSecurityToken();
                this.addIssuedToken((AbstractToken)((IssuedToken)encryptionToken), tok, false, true);
                if (tok == null && !this.isRequestor()) {
                    securityToken = this.findInboundSecurityToken(WSSecurityEventConstants.SamlToken);
                    tokenId = WSS4JUtils.parseAndStoreStreamingSecurityToken(securityToken, this.message);
                }
            } else if (encryptionToken instanceof SecureConversationToken || encryptionToken instanceof SecurityContextToken || encryptionToken instanceof SpnegoContextToken) {
                tok = this.getSecurityToken();
                if (tok != null && this.isRequestor()) {
                    Map<String, Object> config = this.getProperties();
                    String actionToPerform = "CustomToken";
                    if (config.containsKey("action")) {
                        String action = (String)config.get("action");
                        config.put("action", action + " " + actionToPerform);
                    } else {
                        config.put("action", actionToPerform);
                    }
                } else if (tok == null && !this.isRequestor()) {
                    securityToken = this.findInboundSecurityToken(WSSecurityEventConstants.SecurityContextToken);
                    tokenId = WSS4JUtils.parseAndStoreStreamingSecurityToken(securityToken, this.message);
                }
            } else if (encryptionToken instanceof X509Token) {
                if (this.isRequestor()) {
                    tokenId = this.setupEncryptedKey(encryptionWrapper, encryptionToken);
                } else {
                    securityToken = this.findEncryptedKeyToken();
                    tokenId = WSS4JUtils.parseAndStoreStreamingSecurityToken(securityToken, this.message);
                }
            } else if (encryptionToken instanceof UsernameToken) {
                this.policyNotAsserted((Assertion)this.sbinding, "UsernameTokens not supported with Symmetric binding");
                return;
            }
            this.assertToken(encryptionToken);
            if (tok == null) {
                if (tokenId != null && tokenId.startsWith("#")) {
                    tokenId = tokenId.substring(1);
                }
                tok = WSS4JUtils.getTokenStore(this.message).getToken(tokenId);
            }
            if (!MessageUtils.isRequestor(this.message) || !(encryptionToken instanceof KerberosToken)) {
                this.storeSecurityToken(tok);
            }
            List<SecurePart> encrParts = null;
            List<SecurePart> sigParts = null;
            try {
                encrParts = this.getEncryptedParts();
                sigParts = this.getSignedParts();
            }
            catch (SOAPException ex) {
                throw new Fault(ex);
            }
            this.addSupportingTokens();
            if (encryptionToken != null && encrParts.size() > 0) {
                if (this.isRequestor()) {
                    encrParts.addAll(this.encryptedTokensList);
                } else {
                    this.addSignatureConfirmation(sigParts);
                }
                if (this.sbinding.isEncryptSignature()) {
                    part = new SecurePart(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"), SecurePart.Modifier.Element);
                    encrParts.add(part);
                    this.assertPolicy(new QName(this.sbinding.getName().getNamespaceURI(), "EncryptSignature"));
                }
                this.doEncryption(encryptionWrapper, encrParts, true);
            }
            if (this.timestampAdded) {
                part = new SecurePart(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp"), SecurePart.Modifier.Element);
                sigParts.add(part);
            }
            sigParts.addAll(this.getSignedParts());
            if (sigParts.size() > 0) {
                AbstractTokenWrapper sigAbstractTokenWrapper = this.getSignatureToken();
                AbstractToken sigToken = sigAbstractTokenWrapper.getToken();
                if (sigAbstractTokenWrapper != null && this.isRequestor()) {
                    this.doSignature(sigAbstractTokenWrapper, sigToken, tok, sigParts);
                } else if (!this.isRequestor()) {
                    this.addSignatureConfirmation(sigParts);
                    this.doSignature(sigAbstractTokenWrapper, sigToken, tok, sigParts);
                }
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new Fault(ex);
        }
    }

    private void doSignBeforeEncrypt() {
        AbstractTokenWrapper sigAbstractTokenWrapper = this.getSignatureToken();
        this.assertTokenWrapper(sigAbstractTokenWrapper);
        AbstractToken sigToken = sigAbstractTokenWrapper.getToken();
        String sigTokId = null;
        try {
            Map<String, Object> config;
            String action;
            SecurityToken sigTok = null;
            if (sigToken != null) {
                org.apache.xml.security.stax.securityToken.SecurityToken securityToken;
                if (sigToken instanceof KerberosToken) {
                    sigTok = this.getSecurityToken();
                    if (this.isRequestor()) {
                        this.addKerberosToken((KerberosToken)sigToken, false, true, true);
                    }
                } else if (sigToken instanceof IssuedToken) {
                    sigTok = this.getSecurityToken();
                    this.addIssuedToken((AbstractToken)((IssuedToken)sigToken), sigTok, false, true);
                    if (sigTok == null && !this.isRequestor()) {
                        securityToken = this.findInboundSecurityToken(WSSecurityEventConstants.SamlToken);
                        sigTokId = WSS4JUtils.parseAndStoreStreamingSecurityToken(securityToken, this.message);
                    }
                } else if (sigToken instanceof SecureConversationToken || sigToken instanceof SecurityContextToken || sigToken instanceof SpnegoContextToken) {
                    sigTok = this.getSecurityToken();
                    if (sigTok != null && this.isRequestor()) {
                        Map<String, Object> config2 = this.getProperties();
                        String actionToPerform = "CustomToken";
                        if (config2.containsKey("action")) {
                            action = (String)config2.get("action");
                            config2.put("action", action + " " + actionToPerform);
                        } else {
                            config2.put("action", actionToPerform);
                        }
                    } else if (sigTok == null && !this.isRequestor()) {
                        securityToken = this.findInboundSecurityToken(WSSecurityEventConstants.SecurityContextToken);
                        sigTokId = WSS4JUtils.parseAndStoreStreamingSecurityToken(securityToken, this.message);
                    }
                } else if (sigToken instanceof X509Token) {
                    if (this.isRequestor()) {
                        sigTokId = this.setupEncryptedKey(sigAbstractTokenWrapper, sigToken);
                    } else {
                        securityToken = this.findEncryptedKeyToken();
                        sigTokId = WSS4JUtils.parseAndStoreStreamingSecurityToken(securityToken, this.message);
                    }
                } else if (sigToken instanceof UsernameToken) {
                    this.policyNotAsserted((Assertion)this.sbinding, "UsernameTokens not supported with Symmetric binding");
                    return;
                }
            } else {
                this.policyNotAsserted((Assertion)this.sbinding, "No signature token");
                return;
            }
            this.assertToken(sigToken);
            if (sigTok == null && StringUtils.isEmpty(sigTokId)) {
                this.policyNotAsserted((Assertion)sigAbstractTokenWrapper, "No signature token id");
                return;
            }
            if (sigTok == null) {
                sigTok = WSS4JUtils.getTokenStore(this.message).getToken(sigTokId);
            }
            if (!MessageUtils.isRequestor(this.message) || !(sigToken instanceof KerberosToken)) {
                this.storeSecurityToken(sigTok);
            }
            ArrayList<SecurePart> sigs = new ArrayList<SecurePart>();
            if (this.timestampAdded) {
                SecurePart part = new SecurePart(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp"), SecurePart.Modifier.Element);
                sigs.add(part);
            }
            sigs.addAll(this.getSignedParts());
            if (!this.isRequestor()) {
                this.addSignatureConfirmation(sigs);
            }
            if (!sigs.isEmpty()) {
                this.doSignature(sigAbstractTokenWrapper, sigToken, sigTok, sigs);
            }
            this.addSupportingTokens();
            if (this.isRequestor() && (config = this.getProperties()).containsKey("action") && (action = (String)config.get("action")).contains("SAMLTokenSigned") && action.contains("Signature")) {
                String newAction = action.replaceFirst("Signature", "").trim();
                config.put("action", newAction);
            }
            List<SecurePart> enc = this.getEncryptedParts();
            if (this.sbinding.isEncryptSignature()) {
                SecurePart part = new SecurePart(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"), SecurePart.Modifier.Element);
                enc.add(part);
                this.assertPolicy(new QName(this.sbinding.getName().getNamespaceURI(), "EncryptSignature"));
            }
            if (this.isRequestor()) {
                enc.addAll(this.encryptedTokensList);
            }
            AbstractTokenWrapper encrAbstractTokenWrapper = this.getEncryptionToken();
            this.doEncryption(encrAbstractTokenWrapper, enc, false);
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    private void doEncryption(AbstractTokenWrapper recToken, List<SecurePart> encrParts, boolean externalRef) throws SOAPException {
        if (recToken != null && recToken.getToken() != null) {
            AbstractToken encrToken = recToken.getToken();
            AlgorithmSuite algorithmSuite = this.sbinding.getAlgorithmSuite();
            Map<String, Object> config = this.getProperties();
            String actionToPerform = "Encrypt";
            if (recToken.getToken().getDerivedKeys() == AbstractToken.DerivedKeys.RequireDerivedKeys) {
                actionToPerform = "EncryptDerived";
                if (MessageUtils.isRequestor(this.message) && recToken.getToken() instanceof X509Token) {
                    config.put("derivedTokenReference", "EncryptedKey");
                } else {
                    config.put("derivedTokenReference", "DirectReference");
                }
                AlgorithmSuite.AlgorithmSuiteType algSuiteType = this.sbinding.getAlgorithmSuite().getAlgorithmSuiteType();
                config.put("derivedEncryptionKeyLength", "" + algSuiteType.getEncryptionDerivedKeyLength() / 8);
            }
            if (recToken.getVersion() == SPConstants.SPVersion.SP12) {
                config.put("use200512Namespace", "true");
            }
            if (config.containsKey("action")) {
                String action = (String)config.get("action");
                config.put("action", action + " " + actionToPerform);
            } else {
                config.put("action", actionToPerform);
            }
            String parts = "";
            if (config.containsKey("encryptionParts") && !(parts = (String)config.get("encryptionParts")).endsWith(";")) {
                parts = parts + ";";
            }
            if (encrParts != null) {
                for (SecurePart part : encrParts) {
                    QName name = part.getName();
                    parts = parts + "{" + part.getModifier() + "}{" + name.getNamespaceURI() + "}" + name.getLocalPart() + ";";
                }
            }
            config.put("encryptionParts", parts);
            if (this.isRequestor()) {
                config.put("encryptionKeyIdentifier", this.getKeyIdentifierType(recToken, encrToken));
                config.put("derivedTokenKeyIdentifier", "DirectReference");
            } else if (recToken.getToken() instanceof KerberosToken && !this.isRequestor()) {
                config.put("encryptionKeyIdentifier", "KerberosSHA1");
                config.put("derivedTokenKeyIdentifier", "KerberosSHA1");
                if (recToken.getToken().getDerivedKeys() == AbstractToken.DerivedKeys.RequireDerivedKeys) {
                    config.put("encryptionKeyIdentifier", "DirectReference");
                }
            } else if ((recToken.getToken() instanceof IssuedToken || recToken.getToken() instanceof SecureConversationToken || recToken.getToken() instanceof SpnegoContextToken) && !this.isRequestor()) {
                config.put("encryptionKeyIdentifier", "DirectReference");
            } else {
                config.put("encryptionKeyIdentifier", "EncryptedKeySHA1");
                if (recToken.getToken().getDerivedKeys() == AbstractToken.DerivedKeys.RequireDerivedKeys) {
                    config.put("derivedTokenKeyIdentifier", "EncryptedKeySHA1");
                    config.put("encryptionKeyIdentifier", "DirectReference");
                    config.put("encryptSymmetricEncryptionKey", "false");
                }
            }
            config.put("encryptionKeyTransportAlgorithm", algorithmSuite.getAlgorithmSuiteType().getAsymmetricKeyWrap());
            config.put("encryptionSymAlgorithm", algorithmSuite.getAlgorithmSuiteType().getEncryption());
            String encUser = (String)this.message.getContextualProperty("ws-security.encryption.username");
            if (encUser != null) {
                config.put("encryptionUser", encUser);
            }
            if (encrToken instanceof KerberosToken || encrToken instanceof IssuedToken || encrToken instanceof SpnegoContextToken || encrToken instanceof SecurityContextToken || encrToken instanceof SecureConversationToken) {
                config.put("encryptSymmetricEncryptionKey", "false");
            }
        }
    }

    private void doSignature(AbstractTokenWrapper wrapper, AbstractToken policyToken, SecurityToken tok, List<SecurePart> sigParts) throws WSSecurityException, SOAPException {
        Map<String, Object> config = this.getProperties();
        String actionToPerform = "Signature";
        if (wrapper.getToken().getDerivedKeys() == AbstractToken.DerivedKeys.RequireDerivedKeys) {
            actionToPerform = "SignatureDerived";
            if (MessageUtils.isRequestor(this.message) && policyToken instanceof X509Token) {
                config.put("derivedTokenReference", "EncryptedKey");
            } else {
                config.put("derivedTokenReference", "DirectReference");
            }
            AlgorithmSuite.AlgorithmSuiteType algSuiteType = this.sbinding.getAlgorithmSuite().getAlgorithmSuiteType();
            config.put("derivedSignatureKeyLength", "" + algSuiteType.getSignatureDerivedKeyLength() / 8);
        }
        if (policyToken.getVersion() == SPConstants.SPVersion.SP12) {
            config.put("use200512Namespace", "true");
        }
        if (config.containsKey("action")) {
            String action = (String)config.get("action");
            if (action.contains("KerberosToken")) {
                config.put("action", actionToPerform + " " + action);
            } else {
                config.put("action", action + " " + actionToPerform);
            }
        } else {
            config.put("action", actionToPerform);
        }
        String parts = "";
        if (config.containsKey("signatureParts") && !(parts = (String)config.get("signatureParts")).endsWith(";")) {
            parts = parts + ";";
        }
        String optionalParts = "";
        if (config.containsKey("optionalSignatureParts") && !(optionalParts = (String)config.get("optionalSignatureParts")).endsWith(";")) {
            optionalParts = optionalParts + ";";
        }
        for (SecurePart part : sigParts) {
            QName name = part.getName();
            if (part.isRequired()) {
                parts = parts + "{Element}{" + name.getNamespaceURI() + "}" + name.getLocalPart() + ";";
                continue;
            }
            optionalParts = optionalParts + "{Element}{" + name.getNamespaceURI() + "}" + name.getLocalPart() + ";";
        }
        AbstractToken sigToken = wrapper.getToken();
        if (this.sbinding.isProtectTokens() && sigToken instanceof X509Token && this.isRequestor()) {
            parts = parts + "{Element}{http://www.w3.org/2001/04/xmlenc#}EncryptedKey;";
        }
        config.put("signatureParts", parts);
        config.put("optionalSignatureParts", optionalParts);
        this.configureSignature(wrapper, sigToken, false);
        if (policyToken instanceof X509Token) {
            config.put("includeSignatureToken", "false");
            if (this.isRequestor()) {
                config.put("signatureKeyIdentifier", "EncryptedKey");
            } else {
                config.put("signatureKeyIdentifier", "EncryptedKeySHA1");
                if (wrapper.getToken().getDerivedKeys() == AbstractToken.DerivedKeys.RequireDerivedKeys) {
                    config.put("derivedTokenKeyIdentifier", "EncryptedKeySHA1");
                    config.put("signatureKeyIdentifier", "DirectReference");
                }
            }
        } else if (policyToken instanceof KerberosToken) {
            if (this.isRequestor()) {
                config.put("derivedTokenKeyIdentifier", "DirectReference");
            } else {
                if (wrapper.getToken().getDerivedKeys() == AbstractToken.DerivedKeys.RequireDerivedKeys) {
                    config.put("signatureKeyIdentifier", "DirectReference");
                } else {
                    config.put("signatureKeyIdentifier", "KerberosSHA1");
                }
                config.put("derivedTokenKeyIdentifier", "KerberosSHA1");
            }
        } else if (policyToken instanceof IssuedToken || policyToken instanceof SecurityContextToken || policyToken instanceof SecureConversationToken || policyToken instanceof SpnegoContextToken) {
            if (!this.isRequestor()) {
                config.put("includeSignatureToken", "false");
            } else {
                config.put("includeSignatureToken", "true");
            }
            config.put("derivedTokenKeyIdentifier", "DirectReference");
        }
        if (sigToken.getDerivedKeys() == AbstractToken.DerivedKeys.RequireDerivedKeys) {
            config.put("signatureAlgorithm", this.sbinding.getAlgorithmSuite().getSymmetricSignature());
        }
    }

    private String setupEncryptedKey(AbstractTokenWrapper wrapper, AbstractToken sigToken) throws WSSecurityException {
        Date created = new Date();
        Date expires = new Date();
        expires.setTime(created.getTime() + 300000L);
        SecurityToken tempTok = new SecurityToken(IDGenerator.generateID(null), created, expires);
        KeyGenerator keyGenerator = this.getKeyGenerator(this.sbinding.getAlgorithmSuite().getAlgorithmSuiteType().getEncryption());
        SecretKey symmetricKey = keyGenerator.generateKey();
        tempTok.setKey(symmetricKey);
        tempTok.setSecret(symmetricKey.getEncoded());
        WSS4JUtils.getTokenStore(this.message).add(tempTok);
        return tempTok.getId();
    }

    private org.apache.xml.security.stax.securityToken.SecurityToken findEncryptedKeyToken() throws XMLSecurityException {
        List incomingEventList = (List)this.message.getExchange().get(SecurityEvent.class.getName() + ".in");
        if (incomingEventList != null) {
            org.apache.xml.security.stax.securityToken.SecurityToken token;
            for (SecurityEvent incomingEvent : incomingEventList) {
                if (WSSecurityEventConstants.EncryptedPart != incomingEvent.getSecurityEventType() && WSSecurityEventConstants.EncryptedElement != incomingEvent.getSecurityEventType()) continue;
                token = ((AbstractSecuredElementSecurityEvent)incomingEvent).getSecurityToken();
                if (token.getKeyWrappingToken() != null && token.getKeyWrappingToken().getSecretKey() != null && token.getKeyWrappingToken().getSha1Identifier() != null) {
                    return token.getKeyWrappingToken();
                }
                if (token == null || token.getSecretKey() == null || token.getSha1Identifier() == null) continue;
                return token;
            }
            for (SecurityEvent incomingEvent : incomingEventList) {
                if (WSSecurityEventConstants.SignedPart != incomingEvent.getSecurityEventType() && WSSecurityEventConstants.SignedElement != incomingEvent.getSecurityEventType()) continue;
                token = ((AbstractSecuredElementSecurityEvent)incomingEvent).getSecurityToken();
                if (token.getKeyWrappingToken() != null && token.getKeyWrappingToken().getSecretKey() != null && token.getKeyWrappingToken().getSha1Identifier() != null) {
                    return token.getKeyWrappingToken();
                }
                if (token == null || token.getSecretKey() == null || token.getSha1Identifier() == null) continue;
                return token;
            }
        }
        return null;
    }

    private KeyGenerator getKeyGenerator(String symEncAlgo) throws WSSecurityException {
        try {
            WSSConfig.init();
            String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)symEncAlgo);
            if (keyAlgorithm == null || "".equals(keyAlgorithm)) {
                keyAlgorithm = JCEMapper.translateURItoJCEID((String)symEncAlgo);
            }
            KeyGenerator keyGen = KeyGenerator.getInstance(keyAlgorithm);
            if (symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || symEncAlgo.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes128-gcm")) {
                keyGen.init(128);
            } else if (symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || symEncAlgo.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes192-gcm")) {
                keyGen.init(192);
            } else if (symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || symEncAlgo.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes256-gcm")) {
                keyGen.init(256);
            }
            return keyGen;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)e);
        }
    }
}

