/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyhandlers;

import java.io.IOException;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AbstractCommonBindingHandler;
import org.apache.neethi.Assertion;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractBinding;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.AbstractTokenWrapper;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.model.ContentEncryptedElements;
import org.apache.wss4j.policy.model.EncryptedElements;
import org.apache.wss4j.policy.model.EncryptedParts;
import org.apache.wss4j.policy.model.Header;
import org.apache.wss4j.policy.model.IssuedToken;
import org.apache.wss4j.policy.model.KerberosToken;
import org.apache.wss4j.policy.model.KeyValueToken;
import org.apache.wss4j.policy.model.Layout;
import org.apache.wss4j.policy.model.SamlToken;
import org.apache.wss4j.policy.model.SignedElements;
import org.apache.wss4j.policy.model.SignedParts;
import org.apache.wss4j.policy.model.SupportingTokens;
import org.apache.wss4j.policy.model.SymmetricBinding;
import org.apache.wss4j.policy.model.UsernameToken;
import org.apache.wss4j.policy.model.Wss10;
import org.apache.wss4j.policy.model.Wss11;
import org.apache.wss4j.policy.model.X509Token;
import org.apache.wss4j.policy.model.XPath;
import org.apache.wss4j.policy.stax.PolicyUtils;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.impl.securityToken.KerberosClientSecurityToken;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.SecurePart;
import org.apache.xml.security.stax.impl.securityToken.GenericOutboundSecurityToken;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenConstants;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Element;

public abstract class AbstractStaxBindingHandler
extends AbstractCommonBindingHandler {
    protected boolean timestampAdded;
    protected boolean signatureConfirmationAdded;
    protected Set<SecurePart> encryptedTokensList = new HashSet<SecurePart>();
    protected Map<AbstractToken, SecurePart> endEncSuppTokMap;
    protected Map<AbstractToken, SecurePart> endSuppTokMap;
    protected Map<AbstractToken, SecurePart> sgndEndEncSuppTokMap;
    protected Map<AbstractToken, SecurePart> sgndEndSuppTokMap;
    protected Map<String, SecurityTokenProvider<OutboundSecurityToken>> outboundTokens;
    private final Map<String, Object> properties;
    private AbstractBinding binding;

    public AbstractStaxBindingHandler(Map<String, Object> properties, SoapMessage msg, AbstractBinding binding, Map<String, SecurityTokenProvider<OutboundSecurityToken>> outboundTokens) {
        super(msg);
        this.properties = properties;
        this.binding = binding;
        this.outboundTokens = outboundTokens;
    }

    protected SecurePart addUsernameToken(UsernameToken usernameToken) {
        String password;
        this.assertToken((AbstractToken)usernameToken);
        SPConstants.IncludeTokenType includeToken = usernameToken.getIncludeTokenType();
        if (!this.isTokenRequired(includeToken)) {
            return null;
        }
        Map<String, Object> config = this.getProperties();
        if (config.containsKey("action")) {
            String action = (String)config.get("action");
            config.put("action", action + " " + "UsernameToken");
        } else {
            config.put("action", "UsernameToken");
        }
        UsernameToken.PasswordType passwordType = usernameToken.getPasswordType();
        if (passwordType == UsernameToken.PasswordType.HashPassword) {
            config.put("passwordType", "PasswordDigest");
        } else if (passwordType == UsernameToken.PasswordType.NoPassword) {
            config.put("passwordType", "PasswordNone");
        } else {
            config.put("passwordType", "PasswordText");
        }
        if (usernameToken.isNonce()) {
            config.put("addUsernameTokenNonce", "true");
        }
        if (usernameToken.isCreated()) {
            config.put("addUsernameTokenCreated", "true");
        }
        if (config.get("passwordCallbackRef") == null && (password = (String)this.message.getContextualProperty("ws-security.password")) != null) {
            String username = (String)this.message.getContextualProperty("ws-security.username");
            UTCallbackHandler callbackHandler = new UTCallbackHandler(username, password);
            config.put("passwordCallbackRef", callbackHandler);
        }
        return new SecurePart(WSSConstants.TAG_wsse_UsernameToken, SecurePart.Modifier.Element);
    }

    protected SecurePart addKerberosToken(KerberosToken token, boolean signed, boolean endorsing, boolean encrypting) throws WSSecurityException {
        this.assertToken((AbstractToken)token);
        SPConstants.IncludeTokenType includeToken = token.getIncludeTokenType();
        if (!this.isTokenRequired(includeToken)) {
            return null;
        }
        final SecurityToken secToken = this.getSecurityToken();
        if (secToken == null) {
            this.policyNotAsserted((Assertion)token, "Could not find KerberosToken");
        }
        final KerberosClientSecurityToken wss4jToken = new KerberosClientSecurityToken(secToken.getData(), secToken.getKey(), secToken.getId()){

            public Key getSecretKey(String algorithmURI) throws XMLSecurityException {
                if (secToken.getSecret() != null && algorithmURI != null && !"".equals(algorithmURI)) {
                    return KeyUtils.prepareSecretKey((String)algorithmURI, (byte[])secToken.getSecret());
                }
                return secToken.getKey();
            }
        };
        wss4jToken.setSha1Identifier(secToken.getSHA1());
        SecurityTokenProvider<OutboundSecurityToken> kerberosSecurityTokenProvider = new SecurityTokenProvider<OutboundSecurityToken>(){

            public OutboundSecurityToken getSecurityToken() throws WSSecurityException {
                return wss4jToken;
            }

            public String getId() {
                return wss4jToken.getId();
            }
        };
        this.outboundTokens.put("PROP_USE_THIS_TOKEN_ID_FOR_KERBEROS", kerberosSecurityTokenProvider);
        if (encrypting) {
            this.outboundTokens.put("PROP_USE_THIS_TOKEN_ID_FOR_ENCRYPTION", kerberosSecurityTokenProvider);
        }
        if (endorsing) {
            this.outboundTokens.put("PROP_USE_THIS_TOKEN_ID_FOR_SIGNATURE", kerberosSecurityTokenProvider);
        }
        Map<String, Object> config = this.getProperties();
        String actionToPerform = "KerberosToken";
        if (config.containsKey("action")) {
            String action = (String)config.get("action");
            config.put("action", action + " " + actionToPerform);
        } else {
            config.put("action", actionToPerform);
        }
        SecurePart securePart = new SecurePart(WSSConstants.TAG_wsse_BinarySecurityToken, SecurePart.Modifier.Element);
        securePart.setIdToSign(wss4jToken.getId());
        return securePart;
    }

    protected SecurePart addSamlToken(SamlToken token, boolean signed, boolean endorsing) throws WSSecurityException {
        this.assertToken((AbstractToken)token);
        SPConstants.IncludeTokenType includeToken = token.getIncludeTokenType();
        if (!this.isTokenRequired(includeToken)) {
            return null;
        }
        Map<String, Object> config = this.getProperties();
        Object o = this.message.getContextualProperty("ws-security.saml-callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)o, this.getClass()).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        if (handler == null) {
            this.policyNotAsserted((Assertion)token, "No SAML CallbackHandler available");
            return null;
        }
        config.put("samlCallbackRef", handler);
        String samlAction = "SAMLTokenUnsigned";
        if (signed || endorsing) {
            samlAction = "SAMLTokenSigned";
        }
        if (config.containsKey("action")) {
            String action = (String)config.get("action");
            config.put("action", action + " " + samlAction);
        } else {
            config.put("action", samlAction);
        }
        QName qname = WSSConstants.TAG_saml2_Assertion;
        SamlToken.SamlTokenType tokenType = token.getSamlTokenType();
        if (tokenType == SamlToken.SamlTokenType.WssSamlV11Token10 || tokenType == SamlToken.SamlTokenType.WssSamlV11Token11) {
            qname = WSSConstants.TAG_saml_Assertion;
        }
        return new SecurePart(qname, SecurePart.Modifier.Element);
    }

    protected SecurePart addIssuedToken(AbstractToken token, SecurityToken secToken, boolean signed, boolean endorsing) {
        this.assertToken(token);
        if (this.isTokenRequired(token.getIncludeTokenType())) {
            final Element el = secToken.getToken();
            if (el != null && "Assertion".equals(el.getLocalName()) && ("urn:oasis:names:tc:SAML:1.0:assertion".equals(el.getNamespaceURI()) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(el.getNamespaceURI()))) {
                SubjectBean subjectBean;
                Map<String, Object> config;
                String samlAction = "SAMLTokenUnsigned";
                if (endorsing) {
                    samlAction = "SAMLTokenSigned";
                }
                if ((config = this.getProperties()).containsKey("action")) {
                    String action = (String)config.get("action");
                    config.put("action", action + " " + samlAction);
                } else {
                    config.put("action", samlAction);
                }
                if (signed || endorsing) {
                    KeyInfoBean keyInfo = new KeyInfoBean();
                    keyInfo.setCertificate(secToken.getX509Certificate());
                    keyInfo.setEphemeralKey(secToken.getSecret());
                    subjectBean = new SubjectBean("", "", "");
                    subjectBean.setKeyInfo(keyInfo);
                } else {
                    subjectBean = null;
                }
                CallbackHandler callbackHandler = new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) {
                        for (Callback callback : callbacks) {
                            if (!(callback instanceof SAMLCallback)) continue;
                            SAMLCallback samlCallback = (SAMLCallback)callback;
                            samlCallback.setAssertionElement(el);
                            samlCallback.setSubject(subjectBean);
                            if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(el.getNamespaceURI())) {
                                samlCallback.setSamlVersion(SAMLVersion.VERSION_11);
                                continue;
                            }
                            samlCallback.setSamlVersion(SAMLVersion.VERSION_20);
                        }
                    }
                };
                config.put("samlCallbackRef", callbackHandler);
                QName qname = WSSConstants.TAG_saml2_Assertion;
                if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(el.getNamespaceURI())) {
                    qname = WSSConstants.TAG_saml_Assertion;
                }
                return new SecurePart(qname, SecurePart.Modifier.Element);
            }
            if (this.isRequestor()) {
                Map<String, Object> config = this.getProperties();
                String actionToPerform = "CustomToken";
                if (config.containsKey("action")) {
                    String action = (String)config.get("action");
                    config.put("action", action + " " + actionToPerform);
                } else {
                    config.put("action", actionToPerform);
                }
            }
        }
        return null;
    }

    protected void storeSecurityToken(SecurityToken tok) {
        SecurityTokenConstants.TokenType tokenType = WSSecurityTokenConstants.EncryptedKeyToken;
        if (tok.getTokenType() != null) {
            if (tok.getTokenType().startsWith("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#")) {
                tokenType = WSSecurityTokenConstants.KerberosToken;
            } else if (tok.getTokenType().startsWith("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0") || tok.getTokenType().startsWith("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1")) {
                tokenType = WSSecurityTokenConstants.Saml11Token;
            } else if (tok.getTokenType().startsWith("http://schemas.xmlsoap.org/ws/2005/02/sc") || tok.getTokenType().startsWith("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512")) {
                tokenType = WSSecurityTokenConstants.SecureConversationToken;
            }
        }
        final Key key = tok.getKey();
        final byte[] secret = tok.getSecret();
        X509Certificate[] certs = new X509Certificate[1];
        if (tok.getX509Certificate() != null) {
            certs[0] = tok.getX509Certificate();
        }
        final GenericOutboundSecurityToken encryptedKeySecurityToken = new GenericOutboundSecurityToken(tok.getId(), tokenType, key, certs){

            public Key getSecretKey(String algorithmURI) throws XMLSecurityException {
                if (secret != null && algorithmURI != null && !"".equals(algorithmURI)) {
                    return KeyUtils.prepareSecretKey((String)algorithmURI, (byte[])secret);
                }
                if (key != null) {
                    return key;
                }
                if (secret != null) {
                    String jceAlg = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithmURI);
                    if (jceAlg == null || "".equals(jceAlg)) {
                        jceAlg = "HmacSHA1";
                    }
                    return new SecretKeySpec(secret, jceAlg);
                }
                return super.getSecretKey(algorithmURI);
            }
        };
        SecurityTokenProvider<OutboundSecurityToken> encryptedKeySecurityTokenProvider = new SecurityTokenProvider<OutboundSecurityToken>(){

            public OutboundSecurityToken getSecurityToken() throws XMLSecurityException {
                return encryptedKeySecurityToken;
            }

            public String getId() {
                return encryptedKeySecurityToken.getId();
            }
        };
        encryptedKeySecurityToken.setSha1Identifier(tok.getSHA1());
        this.outboundTokens.put("PROP_USE_THIS_TOKEN_ID_FOR_ENCRYPTION", encryptedKeySecurityTokenProvider);
        this.outboundTokens.put("PROP_USE_THIS_TOKEN_ID_FOR_SIGNATURE", encryptedKeySecurityTokenProvider);
        this.outboundTokens.put("PROP_USE_THIS_TOKEN_ID_FOR_CUSTOM_TOKEN", encryptedKeySecurityTokenProvider);
    }

    protected void configureTimestamp(AssertionInfoMap aim) {
        if (this.binding != null && this.binding.isIncludeTimestamp()) {
            this.timestampAdded = true;
            this.assertPolicy(new QName(this.binding.getName().getNamespaceURI(), "IncludeTimestamp"));
        }
    }

    protected void configureLayout(AssertionInfoMap aim) {
        boolean timestampLast;
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "Layout");
        Layout layout = null;
        for (AssertionInfo ai : ais) {
            layout = (Layout)ai.getAssertion();
            Collection layoutTypeAis = (Collection)aim.get(layout.getName());
            if (layoutTypeAis != null) {
                for (AssertionInfo layoutAi : layoutTypeAis) {
                    layoutAi.setAsserted(true);
                }
            }
            ai.setAsserted(true);
        }
        if (layout != null && layout.getLayoutType() != null) {
            this.assertPolicy(new QName(layout.getName().getNamespaceURI(), layout.getLayoutType().name()));
        }
        if (!this.timestampAdded) {
            return;
        }
        Map<String, Object> config = this.getProperties();
        boolean bl = timestampLast = layout != null && layout.getLayoutType() == Layout.LayoutType.LaxTsLast;
        if (config.containsKey("action")) {
            String action = (String)config.get("action");
            if (timestampLast) {
                config.put("action", "Timestamp " + action);
            } else {
                config.put("action", action + " " + "Timestamp");
            }
        } else {
            config.put("action", "Timestamp");
        }
    }

    protected Map<String, Object> getProperties() {
        return this.properties;
    }

    protected void configureSignature(AbstractTokenWrapper wrapper, AbstractToken token, boolean attached) throws WSSecurityException {
        X509Token x509Token;
        X509Token.TokenType tokenType;
        Map<String, Object> config = this.getProperties();
        if (token instanceof X509Token && ((tokenType = (x509Token = (X509Token)token).getTokenType()) == X509Token.TokenType.WssX509PkiPathV1Token10 || tokenType == X509Token.TokenType.WssX509PkiPathV1Token11)) {
            config.put("useSingleCertificate", "false");
        }
        config.put("signatureKeyIdentifier", this.getKeyIdentifierType(wrapper, token));
        if (token instanceof X509Token && this.isTokenRequired(token.getIncludeTokenType()) && ("IssuerSerial".equals(config.get("signatureKeyIdentifier")) || "Thumbprint".equals(config.get("signatureKeyIdentifier")) || "DirectReference".equals(config.get("signatureKeyIdentifier")))) {
            config.put("includeSignatureToken", "true");
        } else {
            config.put("includeSignatureToken", "false");
        }
        String userNameKey = "ws-security.signature.username";
        if (this.binding instanceof SymmetricBinding) {
            userNameKey = "ws-security.encryption.username";
            config.put("signatureAlgorithm", this.binding.getAlgorithmSuite().getSymmetricSignature());
        } else {
            config.put("signatureAlgorithm", this.binding.getAlgorithmSuite().getAsymmetricSignature());
        }
        String sigUser = (String)this.message.getContextualProperty(userNameKey);
        if (sigUser != null) {
            config.put("signatureUser", sigUser);
        }
        AlgorithmSuite.AlgorithmSuiteType algType = this.binding.getAlgorithmSuite().getAlgorithmSuiteType();
        config.put("signatureDigestAlgorithm", algType.getDigest());
    }

    protected String getKeyIdentifierType(AbstractTokenWrapper wrapper, AbstractToken token) {
        String identifier = null;
        if (token instanceof X509Token) {
            X509Token x509Token = (X509Token)token;
            if (x509Token.isRequireIssuerSerialReference()) {
                identifier = "IssuerSerial";
            } else if (x509Token.isRequireKeyIdentifierReference()) {
                identifier = "SKIKeyIdentifier";
            } else if (x509Token.isRequireThumbprintReference()) {
                identifier = "Thumbprint";
            }
        } else if (token instanceof KeyValueToken) {
            identifier = "KeyValue";
        }
        if (identifier != null) {
            return identifier;
        }
        if (token.getIncludeTokenType() == SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER) {
            Wss10 wss = this.getWss10();
            if (wss == null || wss.isMustSupportRefKeyIdentifier()) {
                return "SKIKeyIdentifier";
            }
            if (wss.isMustSupportRefIssuerSerial()) {
                return "IssuerSerial";
            }
            if (wss instanceof Wss11 && ((Wss11)wss).isMustSupportRefThumbprint()) {
                return "Thumbprint";
            }
        } else {
            return "DirectReference";
        }
        return "IssuerSerial";
    }

    protected Map<AbstractToken, SecurePart> handleSupportingTokens(Collection<Assertion> tokens, boolean signed, boolean endorse) throws Exception {
        HashMap<AbstractToken, SecurePart> ret = new HashMap<AbstractToken, SecurePart>();
        if (tokens != null) {
            for (Assertion pa : tokens) {
                if (!(pa instanceof SupportingTokens)) continue;
                this.handleSupportingTokens((SupportingTokens)pa, signed, endorse, ret);
            }
        }
        return ret;
    }

    protected Map<AbstractToken, SecurePart> handleSupportingTokens(SupportingTokens suppTokens, boolean signed, boolean endorse) throws Exception {
        return this.handleSupportingTokens(suppTokens, signed, endorse, new HashMap<AbstractToken, SecurePart>());
    }

    protected Map<AbstractToken, SecurePart> handleSupportingTokens(SupportingTokens suppTokens, boolean signed, boolean endorse, Map<AbstractToken, SecurePart> ret) throws Exception {
        if (suppTokens == null) {
            return ret;
        }
        for (AbstractToken token : suppTokens.getTokens()) {
            SecurePart securePart;
            this.assertToken(token);
            if (!this.isTokenRequired(token.getIncludeTokenType())) continue;
            if (token instanceof UsernameToken) {
                this.handleUsernameTokenSupportingToken((UsernameToken)token, endorse, suppTokens.isEncryptedToken(), ret);
                continue;
            }
            if (token instanceof IssuedToken) {
                SecurityToken sigTok = this.getSecurityToken();
                SecurePart securePart2 = this.addIssuedToken((AbstractToken)((IssuedToken)token), sigTok, signed, endorse);
                if (securePart2 == null) continue;
                ret.put(token, securePart2);
                if (!suppTokens.isEncryptedToken()) continue;
                this.encryptedTokensList.add(securePart2);
                continue;
            }
            if (token instanceof KerberosToken) {
                securePart = this.addKerberosToken((KerberosToken)token, signed, endorse, false);
                if (securePart == null) continue;
                ret.put(token, securePart);
                if (!suppTokens.isEncryptedToken()) continue;
                this.encryptedTokensList.add(securePart);
                continue;
            }
            if (token instanceof X509Token || token instanceof KeyValueToken) {
                this.assertToken(token);
                this.configureSignature((AbstractTokenWrapper)suppTokens, token, false);
                if (suppTokens.isEncryptedToken()) {
                    SecurePart part = new SecurePart(WSSConstants.TAG_wsse_BinarySecurityToken, SecurePart.Modifier.Element);
                    this.encryptedTokensList.add(part);
                }
                ret.put(token, new SecurePart(WSSConstants.TAG_dsig_Signature, SecurePart.Modifier.Element));
                continue;
            }
            if (!(token instanceof SamlToken) || (securePart = this.addSamlToken((SamlToken)token, signed, endorse)) == null) continue;
            ret.put(token, securePart);
            if (!suppTokens.isEncryptedToken()) continue;
            this.encryptedTokensList.add(securePart);
        }
        return ret;
    }

    protected void handleUsernameTokenSupportingToken(UsernameToken token, boolean endorse, boolean encryptedToken, Map<AbstractToken, SecurePart> ret) throws Exception {
        if (endorse) {
            throw new Exception("Endorsing UsernameTokens are not supported in the streaming code");
        }
        SecurePart securePart = this.addUsernameToken(token);
        if (securePart != null) {
            ret.put((AbstractToken)token, securePart);
            if (encryptedToken || MessageUtils.getContextualBoolean(this.message, "ws-security.username-token.always.encrypted", true)) {
                this.encryptedTokensList.add(securePart);
            }
        }
    }

    protected void addSupportingTokens() throws Exception {
        Collection<Assertion> sgndSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_SUPPORTING_TOKENS);
        Map<AbstractToken, SecurePart> sigSuppTokMap = this.handleSupportingTokens(sgndSuppTokens, true, false);
        sgndSuppTokens = this.findAndAssertPolicy(SP11Constants.SIGNED_SUPPORTING_TOKENS);
        sigSuppTokMap.putAll(this.handleSupportingTokens(sgndSuppTokens, true, false));
        Collection<Assertion> endSuppTokens = this.findAndAssertPolicy(SP12Constants.ENDORSING_SUPPORTING_TOKENS);
        this.endSuppTokMap = this.handleSupportingTokens(endSuppTokens, false, true);
        endSuppTokens = this.findAndAssertPolicy(SP11Constants.ENDORSING_SUPPORTING_TOKENS);
        this.endSuppTokMap.putAll(this.handleSupportingTokens(endSuppTokens, false, true));
        Collection<Assertion> sgndEndSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS);
        this.sgndEndSuppTokMap = this.handleSupportingTokens(sgndEndSuppTokens, true, true);
        sgndEndSuppTokens = this.findAndAssertPolicy(SP11Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS);
        this.sgndEndSuppTokMap.putAll(this.handleSupportingTokens(sgndEndSuppTokens, true, true));
        Collection<Assertion> sgndEncryptedSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS);
        Map<AbstractToken, SecurePart> sgndEncSuppTokMap = this.handleSupportingTokens(sgndEncryptedSuppTokens, true, false);
        Collection<Assertion> endorsingEncryptedSuppTokens = this.findAndAssertPolicy(SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS);
        this.endEncSuppTokMap = this.handleSupportingTokens(endorsingEncryptedSuppTokens, false, true);
        Collection<Assertion> sgndEndEncSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS);
        this.sgndEndEncSuppTokMap = this.handleSupportingTokens(sgndEndEncSuppTokens, true, true);
        Collection<Assertion> supportingToks = this.findAndAssertPolicy(SP12Constants.SUPPORTING_TOKENS);
        this.handleSupportingTokens(supportingToks, false, false);
        supportingToks = this.findAndAssertPolicy(SP11Constants.SUPPORTING_TOKENS);
        this.handleSupportingTokens(supportingToks, false, false);
        Collection<Assertion> encryptedSupportingToks = this.findAndAssertPolicy(SP12Constants.ENCRYPTED_SUPPORTING_TOKENS);
        this.handleSupportingTokens(encryptedSupportingToks, false, false);
        this.addSignatureParts(sigSuppTokMap);
        this.addSignatureParts(sgndEncSuppTokMap);
        this.addSignatureParts(this.sgndEndSuppTokMap);
        this.addSignatureParts(this.sgndEndEncSuppTokMap);
    }

    protected void addSignatureParts(Map<AbstractToken, SecurePart> tokenMap) {
        for (AbstractToken token : tokenMap.keySet()) {
            SecurePart part = tokenMap.get(token);
            String parts = "";
            Map<String, Object> config = this.getProperties();
            if (config.containsKey("signatureParts") && !(parts = (String)config.get("signatureParts")).endsWith(";")) {
                parts = parts + ";";
            }
            QName name = part.getName();
            String action = (String)config.get("action");
            if (!WSSConstants.TAG_saml_Assertion.equals(name) && !WSSConstants.TAG_saml2_Assertion.equals(name) || action == null || !action.contains("SAMLTokenSigned")) {
                parts = parts + "{Element}{" + name.getNamespaceURI() + "}" + name.getLocalPart() + ";";
            }
            config.put("signatureParts", parts);
        }
    }

    protected void addSignatureConfirmation(List<SecurePart> sigParts) {
        Wss10 wss10 = this.getWss10();
        if (!(wss10 instanceof Wss11) || !((Wss11)wss10).isRequireSignatureConfirmation()) {
            return;
        }
        Map<String, Object> config = this.getProperties();
        config.put("enableSignatureConfirmation", "true");
        if (sigParts != null) {
            SecurePart securePart = new SecurePart(WSSConstants.TAG_wsse11_SignatureConfirmation, SecurePart.Modifier.Element);
            sigParts.add(securePart);
        }
        this.signatureConfirmationAdded = true;
    }

    protected List<SecurePart> getSignedParts() throws SOAPException {
        SignedParts parts = null;
        SignedElements elements = null;
        AssertionInfoMap aim = this.message.get(AssertionInfoMap.class);
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "SignedParts");
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                parts = (SignedParts)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        if (!(ais = this.getAllAssertionsByLocalname(aim, "SignedElements")).isEmpty()) {
            for (AssertionInfo ai : ais) {
                elements = (SignedElements)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        ArrayList<SecurePart> signedParts = new ArrayList<SecurePart>();
        if (parts != null) {
            if (parts.isBody()) {
                QName soapBody = new QName("http://www.w3.org/2003/05/soap-envelope", "Body");
                SecurePart securePart = new SecurePart(soapBody, SecurePart.Modifier.Element);
                signedParts.add(securePart);
            }
            for (Header head : parts.getHeaders()) {
                String localName = head.getName();
                if (localName == null) {
                    localName = "*";
                }
                QName qname = new QName(head.getNamespace(), localName);
                SecurePart securePart = new SecurePart(qname, SecurePart.Modifier.Element);
                securePart.setRequired(false);
                signedParts.add(securePart);
            }
        }
        if (elements != null && elements.getXPaths() != null) {
            for (XPath xPath : elements.getXPaths()) {
                List qnames = PolicyUtils.getElementPath((XPath)xPath);
                if (qnames.isEmpty()) continue;
                SecurePart securePart = new SecurePart((QName)qnames.get(qnames.size() - 1), SecurePart.Modifier.Element);
                signedParts.add(securePart);
            }
        }
        return signedParts;
    }

    protected List<SecurePart> getEncryptedParts() throws SOAPException {
        SecurePart securePart;
        List qnames;
        EncryptedParts parts = null;
        EncryptedElements elements = null;
        ContentEncryptedElements celements = null;
        AssertionInfoMap aim = this.message.get(AssertionInfoMap.class);
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "EncryptedParts");
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                parts = (EncryptedParts)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        if (!(ais = this.getAllAssertionsByLocalname(aim, "EncryptedElements")).isEmpty()) {
            for (AssertionInfo ai : ais) {
                elements = (EncryptedElements)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        if (!(ais = this.getAllAssertionsByLocalname(aim, "ContentEncryptedElements")).isEmpty()) {
            for (AssertionInfo ai : ais) {
                celements = (ContentEncryptedElements)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        ArrayList<SecurePart> encryptedParts = new ArrayList<SecurePart>();
        if (parts != null) {
            if (parts.isBody()) {
                QName soapBody = new QName("http://www.w3.org/2003/05/soap-envelope", "Body");
                SecurePart securePart2 = new SecurePart(soapBody, SecurePart.Modifier.Content);
                encryptedParts.add(securePart2);
            }
            for (Header head : parts.getHeaders()) {
                String localName = head.getName();
                if (localName == null) {
                    localName = "*";
                }
                QName qname = new QName(head.getNamespace(), localName);
                SecurePart securePart3 = new SecurePart(qname, SecurePart.Modifier.Element);
                securePart3.setRequired(false);
                encryptedParts.add(securePart3);
            }
        }
        if (elements != null && elements.getXPaths() != null) {
            for (XPath xPath : elements.getXPaths()) {
                qnames = PolicyUtils.getElementPath((XPath)xPath);
                if (qnames.isEmpty()) continue;
                securePart = new SecurePart((QName)qnames.get(qnames.size() - 1), SecurePart.Modifier.Element);
                encryptedParts.add(securePart);
            }
        }
        if (celements != null && celements.getXPaths() != null) {
            for (XPath xPath : celements.getXPaths()) {
                qnames = PolicyUtils.getElementPath((XPath)xPath);
                if (qnames.isEmpty()) continue;
                securePart = new SecurePart((QName)qnames.get(qnames.size() - 1), SecurePart.Modifier.Content);
                encryptedParts.add(securePart);
            }
        }
        return encryptedParts;
    }

    protected org.apache.xml.security.stax.securityToken.SecurityToken findInboundSecurityToken(SecurityEventConstants.Event event) throws XMLSecurityException {
        List incomingEventList = (List)this.message.getExchange().get(SecurityEvent.class.getName() + ".in");
        if (incomingEventList != null) {
            for (SecurityEvent incomingEvent : incomingEventList) {
                if (event != incomingEvent.getSecurityEventType()) continue;
                org.apache.xml.security.stax.securityToken.SecurityToken token = ((TokenSecurityEvent)incomingEvent).getSecurityToken();
                return token;
            }
        }
        return null;
    }

    protected static class TokenStoreCallbackHandler
    implements CallbackHandler {
        private CallbackHandler internal;
        private TokenStore store;

        public TokenStoreCallbackHandler(CallbackHandler in, TokenStore st) {
            this.internal = in;
            this.store = st;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                String id = pc.getIdentifier();
                SecurityToken token = this.store.getToken(id);
                if (token == null) continue;
                if (token.getSHA1() == null && pc.getKey() != null) {
                    token.setSHA1(AbstractCommonBindingHandler.getSHA1(pc.getKey()));
                    this.store.add(token.getSHA1(), token);
                }
                pc.setKey(token.getSecret());
                pc.setCustomToken(token.getToken());
                return;
            }
            if (this.internal != null) {
                this.internal.handle(callbacks);
            }
        }
    }

    private static class UTCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public UTCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                WSPasswordCallback pwcb;
                if (!(callback instanceof WSPasswordCallback) || !(pwcb = (WSPasswordCallback)callback).getIdentifier().equals(this.username)) continue;
                pwcb.setPassword(this.password);
            }
        }
    }
}

