/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.security.wss4j.StaxSecurityContextInInterceptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class StaxActionInInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    private static final Logger LOG = LogUtils.getL7dLogger(StaxActionInInterceptor.class);
    private final List<String> inActions;

    public StaxActionInInterceptor(List<String> inActions) {
        super("pre-protocol");
        this.inActions = inActions;
        this.getBefore().add(StaxSecurityContextInInterceptor.class.getName());
    }

    @Override
    public void handleMessage(SoapMessage soapMessage) throws Fault {
        if (this.inActions == null || this.inActions.isEmpty()) {
            return;
        }
        List incomingSecurityEventList = (List)soapMessage.get(SecurityEvent.class.getName() + ".in");
        if (incomingSecurityEventList == null) {
            LOG.warning("Security processing failed (actions mismatch)");
            WSSecurityException ex = new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
            throw this.createSoapFault(soapMessage.getVersion(), ex);
        }
        for (String action : this.inActions) {
            SecurityEventConstants.Event requiredEvent = null;
            if (WSSConstants.TIMESTAMP.getName().equals(action)) {
                requiredEvent = WSSecurityEventConstants.Timestamp;
            } else if (WSSConstants.USERNAMETOKEN.getName().equals(action)) {
                requiredEvent = WSSecurityEventConstants.UsernameToken;
            } else if (WSSConstants.SIGNATURE.getName().equals(action)) {
                requiredEvent = WSSecurityEventConstants.SignatureValue;
            } else if (WSSConstants.SAML_TOKEN_SIGNED.getName().equals(action) || WSSConstants.SAML_TOKEN_UNSIGNED.getName().equals(action)) {
                requiredEvent = WSSecurityEventConstants.SamlToken;
            }
            if (requiredEvent != null && !this.isEventInResults(requiredEvent, incomingSecurityEventList)) {
                LOG.warning("Security processing failed (actions mismatch)");
                WSSecurityException ex = new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
                throw this.createSoapFault(soapMessage.getVersion(), ex);
            }
            if (!WSSConstants.ENCRYPT.getName().equals(action)) continue;
            boolean foundEncryptionPart = this.isEventInResults(WSSecurityEventConstants.EncryptedPart, incomingSecurityEventList);
            if (!foundEncryptionPart) {
                foundEncryptionPart = this.isEventInResults(WSSecurityEventConstants.EncryptedElement, incomingSecurityEventList);
            }
            if (foundEncryptionPart) continue;
            LOG.warning("Security processing failed (actions mismatch)");
            WSSecurityException ex = new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
            throw this.createSoapFault(soapMessage.getVersion(), ex);
        }
    }

    private boolean isEventInResults(SecurityEventConstants.Event event, List<SecurityEvent> incomingSecurityEventList) {
        for (SecurityEvent incomingEvent : incomingSecurityEventList) {
            if (event != incomingEvent.getSecurityEventType()) continue;
            return true;
        }
        return false;
    }

    private SoapFault createSoapFault(SoapVersion version, WSSecurityException e) {
        SoapFault fault;
        QName faultCode = e.getFaultCode();
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(e.getMessage(), (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(e.getMessage(), (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        return fault;
    }
}

